unit CSMPBlok;

interface

uses
  SysUtils, Messages, Classes, Controls, Graphics, Types, ImgList, Math,
  unVeza,XMLIntf, XMLDoc;

type
  TSmer = (smLevo=1,smDole=2,smDesno=3,smGore=4);
  TStanje = (stSelektujem=1 ,stDodajemVezu=2,stKreiramJunction=3);

  TCSMPBlok = class(TCustomControl)
  private
    MDown:boolean;
    FAktivno: boolean;
    FOnAktiviran: TNotifyEvent;
    FSmer: TSmer;
    FOnPromenaSmera: TNotifyEvent;
    FSlikeLevo: TImageList;
    FSlikeDesno: TImageList;
    FSlikeDole: TImageList;
    FSlikeGore: TImageList;
    FAktivneSlike: TImageList;
    FImageIndex: integer;
    FLokalniBroj: integer;
    FNaziv: string;
    FOnDodajVezu: TNotifyEvent;
    FMaxUlaznihVeza: integer;
    FOnBlokMouseMove: TNotifyEvent;
    FOnKreirajJunction: TNotifyEvent;
    FOnBlokClick: TNotifyEvent;
    FOnChange: TNotifyEvent;

    procedure SetImageIndex(const Value: integer);
    procedure SetAktivno(const Value: boolean);
    procedure SetNaziv(const Value: string);
    procedure SetOnAktiviran(const Value: TNotifyEvent);
    procedure SetSmer(const Value: TSmer);
    procedure SetOnPromenaSmera(const Value: TNotifyEvent);
    procedure SetSlikeDesno(const Value: TImageList);
    procedure SetSlikeDole(const Value: TImageList);
    procedure SetSlikeGore(const Value: TImageList);
    procedure SetSlikeLevo(const Value: TImageList);
    procedure SetAktivneSlike(const Value: TImageList);
    function GetNaziv: string;
    procedure SetLokalniBroj(const Value: integer);
    function GetImageIndex: integer;
    function GetlokalniBroj: integer;
    procedure SetOnDodajVezu(const Value: TNotifyEvent);
    function GetIzlaznaTacka: TPoint;
    procedure SetMaxUlaznihVeza(const Value: integer);
    procedure SetOnBlokClick(const Value: TNotifyEvent);
    procedure SetOnBlokMouseMove(const Value: TNotifyEvent);
    procedure SetOnKreirajJunction(const Value: TNotifyEvent);
    procedure SetOnChange(const Value: TNotifyEvent);

  protected
    nX,nY:integer;

    procedure ObrisiUVezu(int:integer);
    procedure ObrisiIVezu(int:integer);

    procedure WMEraseBkgnd( var Msg: TMessage ); message wm_EraseBKGND;
    procedure WMWindowPosChanged(var Message: TWMWindowPosChanged); message WM_WINDOWPOSCHANGED;

  public
    UlazneVeze: TList;
    IzlazneVeze: TList;
    ParI, ParII, ParIII: real;
    Nazivi: array[0..5] of string;
    Stanje: TStanje;

    BrojPar: byte; // Broj parametara
    IzlaznaVrednost: real;
    Sortiran: boolean;
    Sifra: byte;
    BrojUlaza: byte;
    function  GdeUBloku(Veza: TVeza):integer;

    procedure Save(Koren: IXMLNode);
    procedure Load(Koren: IXMLNode);

    function NadjiKrajBlok(uVeza: TVeza):TCSMPBlok;
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy;override;

    procedure DodajUVezu(sender: TVeza; Gde: integer);
    procedure DodajIVezu(sender: TVeza);

    procedure BrisiVezuU(sender: TObject);
    procedure BrisiVezuI(sender: TObject);

    procedure Paint;override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer);override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure RotirajCC;
    procedure RotirajC;
    function VratiUlaz(i: integer): TCSMPBlok;
    function VratiUlaznuTacku(uVeza: TVeza): TPoint;
    procedure OdradiMove;

  published
    property Smer: TSmer read FSmer write SetSmer;
    {Smer je property koji nam govori na koju stranu je dati CSMPBlok okrenut u datom trenutku.
     Moguce vrednosti su smLevo=1, smDole=2, smDesno=3, smGore=4.
     Vrednost ovog property-ja ne treba menjati runo ve preko metoda RotirajCC i RotirajC.}

    property LokalniBroj: integer read GetlokalniBroj write SetLokalniBroj;
    { Lokalni broj sluzi kao jedinstveni identifikator instance objekta TCSMPBlok.
      Na osnovu ovog broja mozemo lako da pristupimo svakom bloku bilo za potrebe uitavanja,
      upisivanja ili dodavanja nove veze.
      LokalniBroj se prikazuje u gornjem levom uglu TCSMPBloka.
      LokalniBroj se azurira prilikom svakog brisanja ili dodavanja nekog od blokova
      (procedurom OdrediBrojeve() klase TCSMPRadnaPovrsina).
      Ovo se radi da bi se odrzala veza izmeu indeksa CSMPBloka u listi blokova
      (unutar TCSMPRadnaPovrsina) i vrednosti promenljive LokalniBroj.
      Takodje, LokalniBroj se koristi i tokom simulacije u unit-u Obrada.
    }

    property SlikeLevo: TImageList read FSlikeLevo write SetSlikeLevo;
    property SlikeDesno: TImageList read FSlikeDesno write SetSlikeDesno;
    property SlikeGore: TImageList read FSlikeGore write SetSlikeGore;
    property SlikeDole: TImageList read FSlikeDole write SetSlikeDole;
    { Prethodna etiri property-ja predstavljaju reference na instancu klase TimageList
      koja u sebi sadrzi ikonice blokova u poloaju Levo, Desno, Gore i Dole.
      Ovi objektni se ne instanciraju za svaki blok ve predstavljaju deljeni resurs.
      Napomena: Inicijalizacija ovih referenci mora da se izvi prilikom kreiranja CSMPBloka
      inae moe doi do neeljenih efekata prilikom iscrtavanja.}

    property ImageIndex: integer read GetImageIndex write SetImageIndex;
    { ImageIndex uva vrednost indeksa ikone datog bloka koja se nalazi u SlikeLevo,
      SlikeDesno, SlikeGore, SlikeDole. Takodje, ImageIndex slui za utvrivanje tipa bloka.
      Samu vrednost ImageIndex dobija prilikom prevlaenja ikonice iz TCSMPBar-a
      na TCSMPRadnaPovrsina. ImageIndex se cuva pod nazivom Sifra u Manifest.xml
      fajlu i prilikom cuvanja samog bloka.}

    property Aktivno: boolean read FAktivno write SetAktivno;
    {Ovo svojstvo TCSMPBlok-a nam govori da li je dati CSMPBlok selektovan ili ne.
     Samo jedan blok moe biti selektovan u jednom trenutku.
     Vrednost ovog svojstva se odrava od strane TCSMPRadnaPovrsina i to na sledei nain:
     Prilikom kreiranja CSMPBloka od strane CSMPRadnePovrsine vri se povezivanje metode
     TCSMPRadnaPovrsina.Aktivacija(Sender:TObject) sa dogadjajem OnAktiviran:TnotifyEvent
     klase CSMPBlok. Na ovaj nain kada god doe do aktiviranja datog bloka poziva se metoda
     Aktivacija koja prolazi kroz sve blokove na CSMPRadnaPovrsina i deaktivira sve ostale
     blokove sem selektovanog.}

    property Naziv: string read GetNaziv write SetNaziv;
    {U nazivu se uva naziv tipa bloka koji sluzi kao tekstualna informacija za korisnika.}

    property AktivneSlike: TImageList read FAktivneSlike write SetAktivneSlike;
    {AktivneSlike predstavljaju referencu na jednu od etiri TimageList-a (Gore, Dole, Levo, Desno)
     i aurira se prilikom svake promene smera.
     Ova referenca se ne instancira vec referencira neki od etiri postojea objekta.}

    property IzlaznaTacka: TPoint read GetIzlaznaTacka;
    {IzlaznaTacka predstavlja poziciju na kojoj se izlazna veza
     vezuje za dati blok. Data tacka zavisi od smera CSMPBloka kao i njegove pozicije na ekranu.
     Tacka je data relativno u odnosu na TCSMPRadnaPovrsina na kojoj se nalazi dati CSMPBlok.}

    property MaxUlaznihVeza: integer read FMaxUlaznihVeza write SetMaxUlaznihVeza;
    {MaxUlaznih veza je property koji uva vrednost koja se odnosi na broj ulaznih veza
     koje CSMPBlok datog tipa moe da ima. Ovaj property moe uzeti vrednost iz intervala 0 do 3.
     Ovo ogranienje je nasleeno iz ranije verzije programa ali je i sasvim korektno jer se
     u radu sa prethodnom aplikacijom dolo do zakljuka da se vie od 3 ulaza vrlo retko
     (ako ne i nikad) koristi. U sluaju da se jednog dana javi potreba da se izvri
     proirenje kapaciteta programa to se lako moe uiniti manjim izmenama u kodu i
     promenom vrednosti u Manifest.xml fajlu.}

    property OnAktiviran: TNotifyEvent read FOnAktiviran write SetOnAktiviran;

    property OnPromenaSmera: TNotifyEvent read FOnPromenaSmera write SetOnPromenaSmera;
    property OnDodajVezu: TNotifyEvent read FOnDodajVezu write SetOnDodajVezu;

    property OnKreirajJunction: TNotifyEvent read FOnKreirajJunction write SetOnKreirajJunction;
    property OnBlokClick: TNotifyEvent read FOnBlokClick write SetOnBlokClick;
    property OnBlokMouseMove: TNotifyEvent read FOnBlokMouseMove write SetOnBlokMouseMove;

    property OnChange: TNotifyEvent read FOnChange write SetOnChange;
  end;

procedure Register;

implementation

var
  FS: TFormatSettings;

procedure Register;
begin
  RegisterComponents('CSMP', [TCSMPBlok]);
end;

{ TCSMPBlok }

procedure TCSMPBlok.BrisiVezuI(sender: TObject);
var
  i:integer;

begin
  i := IzlazneVeze.IndexOf(Sender);
  if (i > -1) then
    IzlazneVeze.Delete(i);

  if Assigned(OnChange) then
    OnChange(Self);
end;

procedure TCSMPBlok.BrisiVezuU(sender: TObject);
var
  i: integer;
begin
  i := UlazneVeze.IndexOf(sender);
  if (i > -1) then
  begin
    UlazneVeze.Items[i] := nil;
    Dec(BrojUlaza);
  end;

  if Assigned(OnChange) then
    OnChange(Self);
end;

constructor TCSMPBlok.Create(AOwner: TComponent);
var
  i: byte;
begin
  inherited;
  FS.DecimalSeparator := '.';
  UlazneVeze := TList.Create;
  for i:=0 to 2 do
    UlazneVeze.Add(nil);

  IzlazneVeze := TList.Create;
  MaxUlaznihVeza:=0;
  Stanje := stSelektujem;
  SetBounds(0, 0, 66, 52);
  nX := 0;
  nY := 0;
  mDown := false;
  smer := smLevo;
  ParI := 0;
  ParII := 0;
  ParIII := 0;
  IzlaznaVrednost := 0;
  Sortiran := False;
  BrojUlaza := 0;
end;

destructor TCSMPBlok.Destroy;
begin
  OnAktiviran := nil;
  UlazneVeze.Free;
  IzlazneVeze.Free;
  inherited;
end;

procedure TCSMPBlok.DodajIVezu(sender: TVeza);
begin
  IzlazneVeze.Add(Sender);

  if Assigned(OnChange) then
    OnChange(Self);
end;

procedure TCSMPBlok.DodajUVezu(Sender: TVeza; Gde: integer);
begin
  UlazneVeze.Items[Gde] := TVeza(Sender);
  Inc(BrojUlaza);
  if Assigned(OnChange) then
    OnChange(Self);
end;

function TCSMPBlok.GdeUBloku(Veza: TVeza): integer;
var
  i: integer;
begin
  for i:=0 to UlazneVeze.Count-1 do
    if UlazneVeze.Items[i] = Veza then
    begin
      Result := i;
      exit;
    end;

  Result := -1;
end;

function TCSMPBlok.GetImageIndex: integer;
begin
  Result := FImageindex;
end;

function TCSMPBlok.GetIzlaznaTacka: TPoint;
var
  pIzlaznaTacka: TPoint;

begin
  case FSmer of
    smLevo:
      begin
        pIzlaznaTacka.X := Left;
        pIzlaznaTacka.Y := Top + (Height div 2);
      end;
    smDesno:
      begin
        pIzlaznaTacka.X := Left + Width;
        pIzlaznaTacka.Y := Top + (Height div 2);
      end;
    smGore:
      begin
        pIzlaznaTacka.X := Left + (Width div 2);
        pIzlaznaTacka.Y := Top;
      end;
    smDole:
      begin
        pIzlaznaTacka.X := Left + (Width div 2);
        pIzlaznaTacka.Y := Top + Height;
      end;
  end;

  Result := pIzlaznaTacka;
end;

function TCSMPBlok.GetLokalniBroj: integer;
begin
  Result := FLokalniBroj;
end;

function TCSMPBlok.GetNaziv: string;
begin
  Result := FNaziv;
end;

procedure TCSMPBlok.Load(Koren: IXMLNode);
var
  pomk: IXMLNode;
  i: integer;
begin
  pomk := Koren;
  Top := StrToInt(pomk.ChildNodes.Nodes['Top'].text);
  Left := StrToInt(pomk.ChildNodes.Nodes['Left'].text);
  Sifra := StrToInt(pomk.ChildNodes.Nodes['Sifra'].text);
  Naziv := pomk.ChildNodes.Nodes['Naziv'].text;
  LokalniBroj := StrToInt(pomk.ChildNodes.Nodes['LokalniBroj'].text);
  BrojPar := StrToInt(pomk.ChildNodes.Nodes['brparam'].text);
  MaxUlaznihVeza := StrToInt(pomk.ChildNodes.Nodes['maxuveza'].text);
  for i:=0 to 5 do
    Nazivi[i] := pomk.ChildNodes.Nodes['str' + IntToStr(i + 1)].text;

  ParI := StrToFloat(pomk.ChildNodes.Nodes['Parametar1'].text, FS);
  ParII := StrToFloat(pomk.ChildNodes.Nodes['Parametar2'].text, FS);
  ParIII := StrToFloat(pomk.ChildNodes.Nodes['Parametar3'].text, FS);
  Smer := TSmer(StrToInt(pomk.ChildNodes.Nodes['Smer'].text));
end;

procedure TCSMPBlok.MouseDown(Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
begin
  inherited;
  mdown := false;

  case Stanje of
    stSelektujem:
      begin
        if ssLeft	in Shift then
        begin
          Self.BringToFront;
          MDown := True;
          nX := X;
          nY := Y;
        end;

        if not Aktivno then
        begin
          Aktivno := True;
          if Assigned(OnBlokClick) then
            OnBlokClick(self);
        end;
    end;
    stDodajemVezu:
      begin
        if Assigned(OnBlokClick) then
          OnBlokClick(self);

        if Assigned(OnDodajVezu) then
          OnDodajVezu(self);
        mdown := False;
      end;
    stKreiramJunction:
      begin
        if Assigned(OnBlokClick) then
          OnBlokClick(self);

        if Assigned(OnKreirajJunction) then
          OnKreirajJunction(self);
        mdown := False;
        Stanje := stSelektujem;
      end;
  end;
end;

procedure TCSMPBlok.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
  inherited;
  if Assigned(OnBlokMouseMove) then
    OnBlokMouseMove(Self);

  if MDown then
  begin
    Left := Max(8, Left + X - nx);
    Top := Max(8, Top + Y - nY);

    if Assigned(OnChange) then
      OnChange(Self);
  end;
end;

procedure TCSMPBlok.MouseUp(Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
begin
  inherited;
  MDown := False;

end;

function TCSMPBlok.NadjiKrajBlok(uVeza: TVeza): TCSMPBlok;
begin
  if uVeza.IsJunction then
    Result := NadjiKrajBlok(uVeza.Parent)
  else
    Result := TCSMPBlok(uVeza.PocBlok);
end;

procedure TCSMPBlok.ObrisiIVezu(int: integer);
begin
  if (int < IzlazneVeze.Count) then
    IzlazneVeze.Delete(int);

  IzlazneVeze.Pack;
  if Assigned(OnChange) then
    OnChange(Self);
end;

procedure TCSMPBlok.ObrisiUVezu(int: integer);
begin
  if (int < UlazneVeze.Count) then
    UlazneVeze.Items[int] := nil;

  if Assigned(OnChange) then
    OnChange(Self);
end;

procedure TCSMPBlok.OdradiMove;
var
  i:integer;

begin
  if IzlazneVeze.Count<>0 then
    for i:=0 to IzlazneVeze.Count-1 do
    begin
      if not (TVeza(IzlazneVeze.Items[i]).IsJunction) then
        TVeza(IzlazneVeze.Items[i]).SetSP(IzlaznaTacka);

      TVeza(IzlazneVeze.Items[i]).Paint;
    end;

  if UlazneVeze.Count<>0 then
    for i:=0 to UlazneVeze.Count-1 do
      if (UlazneVeze.Items[i] <> nil) then
      begin
        TVeza(UlazneVeze.Items[i]).SetEP(VratiUlaznuTacku(TVeza(UlazneVeze.Items[i])));

      TVeza(UlazneVeze.Items[i]).Paint;
      end;
  Refresh;
end;

procedure TCSMPBlok.Paint;
var
  rec:TRect;
begin
  inherited;
  self.Canvas.Brush.Color:=clWhite;
  self.Canvas.Pen.Color:=clBlack;
  Canvas.Pen.Style:=psSolid;
  rec:=Self.GetClientRect;
  Canvas.RoundRect(rec.Left,rec.Top,rec.Right,rec.Bottom,10,10);
  if Aktivno then
  begin
    Canvas.Pen.Color:=clBlue;
    Canvas.Pen.Style:=psDot;
    Canvas.RoundRect(rec.Left+2,rec.Top+2,rec.Right-2,rec.Bottom-2,10,10);
  end;
  if AktivneSlike<>nil then
    AktivneSlike.Draw(Canvas, 20, 5, ImageIndex, true);
  canvas.Font.Style:=[fsBold];
  canvas.Brush.Style:=bsClear;
  canvas.TextOut(5,5,inttostr(LokalniBroj));
end;

procedure TCSMPBlok.RotirajC;
begin
  if Ord(Smer)>1 then
    Smer:=TSmer(Ord(Smer)-1)
  else
    Smer:=TSmer(4);
  OdradiMove;
  Invalidate;

  if Assigned(OnChange) then
    OnChange(Self);
end;

procedure TCSMPBlok.RotirajCC;
begin
  if Ord(Smer)<4 then
    Smer:=TSmer(Ord(Smer)+1)
  else
    Smer:=TSmer(1);
  OdradiMove;
  Invalidate;

  if Assigned(OnChange) then
    OnChange(Self);
end;

procedure TCSMPBlok.Save(Koren: IXMLNode);
var
  pom, pom2: IXMLNode;
  i: integer;
begin
  pom := koren.AddChild('Blok');
  pom2 := pom.AddChild('Top');
  pom2.Text := IntToStr(Top);
  pom2 := pom.AddChild('Left');
  pom2.Text := IntToStr(Left);
  pom2 := pom.AddChild('Sifra');
  pom2.Text := IntToStr(Sifra);
  pom2 := pom.AddChild('Naziv');
  pom2.Text := Naziv;
  pom2 := pom.AddChild('LokalniBroj');
  pom2.Text := IntToStr(LokalniBroj);
  pom2 := pom.AddChild('brparam');
  pom2.Text := IntToStr(BrojPar);
  pom2 := pom.AddChild('maxuveza');
  pom2.Text := IntToStr(MaxUlaznihVeza);
  for i := 0 to 5 do
  begin
    pom2 := pom.AddChild('str'+inttostr(i+1));
    pom2.Text := Nazivi[i];
  end;
  pom2 := pom.AddChild('Parametar1');
  pom2.Text := FloatToStr(ParI, FS);
  pom2 := pom.AddChild('Parametar2');
  pom2.Text := FloatToStr(ParII, FS);
  pom2 := pom.AddChild('Parametar3');
  pom2.Text := FloatToStr(ParIII, FS);
  pom2 := pom.AddChild('Smer');
  pom2.Text := IntToStr(ord(Smer));
end;

procedure TCSMPBlok.SetAktivneSlike(const Value: TImageList);
begin
  FAktivneSlike := Value;
end;

procedure TCSMPBlok.SetAktivno(const Value: boolean);
begin
  if FAktivno<>Value then
  begin
    FAktivno := Value;
    Invalidate;
  end;
  if FAktivno and Assigned(OnAktiviran) then
    OnAktiviran(self);
end;

procedure TCSMPBlok.SetImageIndex(const Value: integer);
begin
  FImageIndex:=GetImageindex;
  if AktivneSlike<>nil then
  begin
    if value<AktivneSlike.Count then
    if (FImageIndex<>Value) then
    begin
      FImageIndex:=Value;
      Invalidate;
    end;
  end
  else
  begin
    FImageIndex:=Value;
  end;
end;

procedure TCSMPBlok.SetLokalniBroj(const Value: integer);
begin
  if FLokalniBroj<>value then
  begin
    FLokalniBroj:=value;
    invalidate;
  end;
end;

procedure TCSMPBlok.SetMaxUlaznihVeza(const Value: integer);
begin
  FMaxUlaznihVeza := Value;
end;

procedure TCSMPBlok.SetNaziv(const Value: string);
begin
  FNaziv:=value;
end;

procedure TCSMPBlok.SetOnAktiviran(const Value: TNotifyEvent);
begin
  FOnAktiviran := Value;
end;

procedure TCSMPBlok.SetOnBlokClick(const Value: TNotifyEvent);
begin
  FOnBlokClick := Value;
end;

procedure TCSMPBlok.SetOnBlokMouseMove(const Value: TNotifyEvent);
begin
  FOnBlokMouseMove := Value;
end;

procedure TCSMPBlok.SetOnChange(const Value: TNotifyEvent);
begin
  FOnChange := Value;
end;

procedure TCSMPBlok.SetOnDodajVezu(const Value: TNotifyEvent);
begin
  FOnDodajVezu := Value;
end;

procedure TCSMPBlok.SetOnKreirajJunction(const Value: TNotifyEvent);
begin
  FOnKreirajJunction := Value;
end;

procedure TCSMPBlok.SetOnPromenaSmera(const Value: TNotifyEvent);
begin
  FOnPromenaSmera := Value;
end;

procedure TCSMPBlok.SetSlikeDesno(const Value: TImageList);
begin
  FSlikeDesno := Value;
end;

procedure TCSMPBlok.SetSlikeDole(const Value: TImageList);
begin
  FSlikeDole := Value;
end;

procedure TCSMPBlok.SetSlikeGore(const Value: TImageList);
begin
  FSlikeGore := Value;
end;

procedure TCSMPBlok.SetSlikeLevo(const Value: TImageList);
begin
  FSlikeLevo := Value;
end;

procedure TCSMPBlok.SetSmer(const Value: TSmer);
begin
  FSmer := Value;
  case FSmer of
    smLevo:
    begin
      AktivneSlike:=SlikeLevo;
    end;
    smDesno:
    begin
      AktivneSlike:=SlikeDesno;
    end;
    smGore:
    begin
      AktivneSlike:=SlikeGore;
    end;
    smDole:
    begin
      AktivneSlike:=SlikeDole;
    end;
  else
      AktivneSlike:=nil;
  end;

  OdradiMove;

  if Assigned(OnPromenaSmera) then
    OnPromenaSmera(self);
end;

function TCSMPBlok.VratiUlaz(i: integer): TCSMPBlok;
begin
  if (UlazneVeze.Items[i] <> nil) then
    Result := TCSMPBlok(TVeza(UlazneVeze.Items[i]).PocBlok)
  else Result := nil;
end;

function TCSMPBlok.VratiUlaznuTacku(uVeza: TVeza): TPoint;
var
  pUlaznaTacka: TPoint;
  pom: Integer;

begin
  pom := UlazneVeze.IndexOf(uVeza)+1;
  case FSmer of
    smLevo:
    begin
      pUlaznaTacka.X:=Left+Width;
      pUlaznaTacka.Y:=Top+(Height div (MaxUlaznihVeza+1))*pom;
    end;
    smDesno:
    begin
      pUlaznaTacka.X:=Left;
      pUlaznaTacka.Y:=Top+(Height div (MaxUlaznihVeza+1))*pom;
    end;
    smGore:
    begin
      pUlaznaTacka.X:=Left+(Width div (MaxUlaznihVeza+1))*pom;
      pUlaznaTacka.Y:=Top+Height;
    end;
    smDole:
    begin
      pUlaznaTacka.X:=Left+(Width div (MaxUlaznihVeza+1))*pom;
      pUlaznaTacka.Y:=Top;
    end;
  end;
  result:=pUlaznaTacka;
end;

procedure TCSMPBlok.WMEraseBkgnd(var Msg: TMessage);
begin
  Msg.Result := 1;
end;

procedure TCSMPBlok.WMWindowPosChanged(var Message: TWMWindowPosChanged);
begin
  inherited;
  OdradiMove;
end;

end.
