unit CSMPDugme;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TStanjeMisa = ( smUnutar, smVan, smDole );
     { TStanjeMisa je nabrojivi tip koji sluzi da CSMPDugme u svakom trenutku
      zna kakvo je stanje misa u odnosu na njega:
        smUnutar - pokazivac misa je unutar okvira dugmeta (iznad komponente)
        smVan    - pokazivac misa je van okvira dugmeta
        smDole   - dugme misa je pritisnuto (CSMPDugme je kliknuto)}

  TCSMPDugme = class(TCustomControl)
  private    
    FAktivniPanel: TPanel;
    FBoja: TColor;
    FBojaOkvira: TColor;
    FStanjeMisa: TStanjeMisa;
    FTekst: string;
    FOnClick: TNotifyEvent;
    Label1: TLabel;

    procedure SetAktivniPanel(const Value: TPanel);
    procedure SetBoja(const Value: TColor);
    procedure SetBojaOkvira(const Value: TColor);
    procedure SetTekst(const Value: string);
    procedure SetOnClick(const Value: TNotifyEvent);
    procedure LabelMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LabelMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

  protected
    procedure CMMouseEnter( var Msg: TMessage ); message cm_MouseEnter;
    procedure CMMouseLeave( var Msg: TMessage ); message cm_MouseLeave;
    procedure CMEraseBkgnd( var Msg: TMessage ); message wm_EraseBKGND;
    procedure MouseDown(Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer); override;

  public
    constructor Create(AOwner: TComponent); override;
    procedure Paint; override;
    
  published
    property AktivniPanel: TPanel read FAktivniPanel write SetAktivniPanel;
      { AktivniPanel je svojstvo koje sadrzi instancu na panel koji ce da se
        skriva i pokazuje klikom na CSMPDugme }

    property Boja: TColor read FBoja write SetBoja;
      { Boja je glavna boja CSMPDugmeta}

    property BojaOkvira: TColor read FBojaOkvira write SetBojaOkvira;
      { Boja okvira je bojam kojom ce da se iscrta okvir za CSMPDugme}

    property Tekst: string read FTekst write SetTekst;
      { Tekst je string koji se ispisuje na dugmetu }

    property OnClick: TNotifyEvent read FOnClick write SetOnClick;
      { OnClick je dogadjaj koji ce da se desi (ukoliko je postavljen) kada se
        CSMPDugme klikne }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('CSMP', [TCSMPDugme]);
end;

{ TCSMPDugme }

procedure TCSMPDugme.CMEraseBkgnd(var Msg: TMessage);
begin
  Msg.Result := 1;
end;

procedure TCSMPDugme.CMMouseEnter(var Msg: TMessage);
begin
  inherited;
  {$IFDEF VCL70_OR_HIGHER}
  if csDesigning in ComponentState then
    Exit;
  {$ENDIF}
  
  if (FStanjeMisa=smVan) then
    FStanjeMisa := smUnutar;
  invalidate;
end;

procedure TCSMPDugme.CMMouseLeave(var Msg: TMessage);
begin
  FStanjeMisa := smVan;
  invalidate;
end;

constructor TCSMPDugme.Create(AOwner: TComponent);
begin
  inherited;
  FStanjeMisa := smVan;

  Cursor := crHandPoint;
  FAktivniPanel:=nil;
  Align:=alTop;
  Boja:=clBtnFace;
  BojaOkvira:=clBlack;
  Height := 20;

  Label1:=TLabel.Create(Self);
  with Label1 do
  begin
    Parent := Self;
    Left := 20;
    Top := 2;
    Width := 100;
    Height := 12;
    Alignment := taCenter;
    Anchors := [akLeft, akTop, akRight, akBottom];
    AutoSize := False;
    Caption := 'CSMPDugme';
    Transparent := True;
    OnMouseDown := LabelMouseDown;
    OnMouseUp := LabelMouseUp;
  end;
  Tekst:='CSMPDugme';
end;

procedure TCSMPDugme.LabelMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MouseDown(Button, Shift, X, Y)
end;

procedure TCSMPDugme.LabelMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MouseUp(Button, Shift, X, Y)
end;

procedure TCSMPDugme.MouseDown(Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
begin
  inherited;
  FStanjeMisa := smDole;
  invalidate;
end;

procedure TCSMPDugme.MouseUp(Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
var Point: TPoint;
begin
  inherited;
  Point.X:=X;
  Point.Y:=Y;
  if PtInRect(ClientRect, Point){ or PtInRect(Label1.ClientRect, Point)}then
    FStanjeMisa:=smUnutar
  else FStanjeMisa := smVan;

  if (FStanjeMisa = smUnutar) then
    if Assigned(OnClick) then
      OnClick(Self);

  Invalidate;
end;

procedure TCSMPDugme.Paint;
var
  Pom2: integer;
  slika: TBitmap;

begin
  inherited;

  Slika := TBitmap.Create;
  Slika.Width := Width;
  Slika.Height := Height;
  Slika.Canvas.Brush.Style := bsSolid;
  Slika.Canvas.Brush.Color := clBtnFace;
  Slika.Canvas.Pen.Color := clBlack;
  Slika.Canvas.Rectangle(ClientRect);

  if ((FStanjeMisa = smUnutar) or (FStanjeMisa = smDole)) then
    Slika.Canvas.Font.Color := clGray
  else
    Slika.Canvas.Font.Color := clBlack;

  if (FStanjeMisa = smDole) then
    pom2:=3
  else
    pom2:=2;

  Label1.Top := Pom2;
  Label1.Font.Color := Slika.Canvas.Font.Color;

  Canvas.Draw(0,0,Slika);
  Slika.Free;
end;

procedure TCSMPDugme.SetAktivniPanel(const Value: TPanel);
begin
  FAktivniPanel := Value;
end;

procedure TCSMPDugme.SetBoja(const Value: TColor);
begin
  FBoja := Value;
end;

procedure TCSMPDugme.SetBojaOkvira(const Value: TColor);
begin
  FBojaOkvira := Value;
end;

procedure TCSMPDugme.SetOnClick(const Value: TNotifyEvent);
begin
  FOnClick := Value;
end;

procedure TCSMPDugme.SetTekst(const Value: string);
begin
  FTekst := Value;
  Label1.Caption := Value;
  Label1.Left := Left;
  Label1.Width := Width;
  Label1.Height := Height;
end;

end.
