unit CSMPGrupe;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, XMLIntf, XMLDoc, CSMPDugme, Skroler;

type

  TCSMPGrupa = class(TPanel)
  private
    FOnCaptionClick: TNotifyEvent;
    Klik: boolean;
    procedure Kliknuto(Sender: TObject);
    procedure SetOnCaptionClick(const Value: TNotifyEvent);

  protected
    procedure WMErase(var Message: TMessage); message WM_ERASEBKGND;

  public
    MyBody: TPanel;
    MyCaption: TCSMPDugme;

    constructor Create(AOwner: TComponent); override;

  published
    property OnCaptionClick: TNotifyEvent read FOnCaptionClick write SetOnCaptionClick;

  end;

  TCSMPGroupBar = class(TPanel)
  private
    
    FAktivnaGrupa: TCSMPGrupa;
    FSlike: TImageList;
    procedure SetAktivnaGrupa(const Value: TCSMPGrupa);
    procedure WMErase(var Message: TMessage); message WM_ERASEBKGND;
    procedure SetSlike(const Value: TImageList);

  protected
    procedure DodajGrupu(XMLGrupa: IXMLNodeList);
    procedure DodajElemente(XMLGrupa: IXMLNodeList; Grupa:TCSMPGrupa);

  public
    Grupe: TList;

    constructor Create(AOwner: TComponent); override;
    procedure Resize; override;
    procedure CaptionClick(Sender: TObject);
    procedure AddGrupu(Grupa: TCSMPGrupa);
    procedure LoadFromXML(FileName: TFileName);

  published
    property AktivnaGrupa: TCSMPGrupa read FAktivnaGrupa write SetAktivnaGrupa;
    property Slike: TImageList read FSlike write SetSlike;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('CSMP', [TCSMPGroupBar]);
end;

{ TCSMPGrupa }

constructor TCSMPGrupa.Create(AOwner: TComponent);
begin
  inherited;

  Align := alNone;
  BevelOuter := bvNone;
  Color := clBtnFace;
  Klik:=True;

  MyCaption := TCSMPDugme.Create(Self);
  with MyCaption do
  begin
    Parent := Self;
    Left := 0;
    Top := 0;
    Width := 149;
    Height := 20;
    Cursor := crHandPoint;
    Align := alTop;
    Caption := 'Grupa';
    OnClick := Kliknuto;
  end;

  MyBody := TPanel.Create(Self);
  with MyBody do
  begin
    Parent := Self;
    Align := alClient;
    Left := 0;
    Top := 20;
    Width := 149;
    Height:=200;
    Align := alTop;
    BevelOuter := bvNone;
    Color := clBtnFace;
  end;
end;

procedure TCSMPGrupa.SetOnCaptionClick(const Value: TNotifyEvent);
begin
  FOnCaptionClick := Value;
end;

procedure TCSMPGrupa.Kliknuto(Sender: TObject);
begin
  if Assigned(OnCaptionClick) then
    OnCaptionClick(Self)
end;

procedure TCSMPGrupa.WMErase(var Message: TMessage);
begin
  message.Result:=1;
end;

{ TCSMPGroupBar }

procedure TCSMPGroupBar.CaptionClick(Sender: TObject);
begin
  AktivnaGrupa := TCSMPGrupa(Sender);
  Invalidate;
end;

constructor TCSMPGroupBar.Create(AOwner: TComponent);
begin
  inherited;

  Align := alLeft;
  BevelInner := bvLowered;
  Color := clBtnFace;
  Grupe := TList.Create;
  AktivnaGrupa:=nil;
end;

procedure TCSMPGroupBar.AddGrupu(Grupa: TCSMPGrupa);
begin
  Grupa.OnCaptionClick := CaptionClick;
  Grupe.Add(Grupa);
  AktivnaGrupa := TCSMPGrupa(Grupe.Items[0]);
end;

procedure TCSMPGroupBar.SetAktivnaGrupa(const Value: TCSMPGrupa);
var
  i, pomHeight, FOpenedHeight: integer;

begin
  FAktivnaGrupa := Value;
  FOpenedHeight := Height - 3;
  for i := 0 to (Grupe.Count - 1) do
    if TCSMPGrupa(Grupe.Items[i]).Visible then
      FOpenedHeight := FOpenedHeight - TCSMPGrupa(Grupe.Items[i]).MyCaption.Height;

  pomHeight := -20;
  if (AktivnaGrupa <> nil) then
  begin
    for i := 0 to (Grupe.Count - 1) do
    begin
      if (TCSMPGrupa(Grupe.Items[i]) = AktivnaGrupa) then
      begin
        AktivnaGrupa.SetBounds(0, pomHeight, Self.Width, FOpenedHeight + AktivnaGrupa.MyCaption.Height);
        AktivnaGrupa.MyBody.Height := FOpenedHeight;
      end
      else
      begin
        TCSMPGrupa(Grupe.Items[i]).SetBounds(0, pomHeight, Self.Width,
          TCSMPGrupa(Grupe.Items[i]).MyCaption.Height);
      end;
      inc(pomHeight, TCSMPGrupa(Grupe.Items[i]).Height);
    end;
  end;
end;

procedure TCSMPGroupBar.Resize;
begin
  inherited;
  AktivnaGrupa := AktivnaGrupa;
end;

procedure TCSMPGroupBar.WMErase(var Message: TMessage);
begin
  Message.Result := 1;
end;

procedure TCSMPGroupBar.SetSlike(const Value: TImageList);
begin
  FSlike := Value;
end;

procedure TCSMPGroupBar.DodajElemente(XMLGrupa: IXMLNodeList;
  Grupa: TCSMPGrupa);
var
  Skroler: TSkroler;

begin
  Skroler := TSkroler.Create(Grupa.MyBody);
  Skroler.Parent := Grupa.MyBody;
  Skroler.Align := alClient;
  Skroler.Color := clGrayText;
  Skroler.Slike := Slike;
  Skroler.LoadFromXMLManifest(XMLGrupa);
end;

procedure TCSMPGroupBar.DodajGrupu(XMLGrupa: IXMLNodeList);
var
  pomGrupa: TCSMPGrupa;
  i: integer;

begin
  for i:=0 to XMLGrupa.Count-1 do
  begin
    pomGrupa := TCSMPGrupa.Create(Self);
    pomGrupa.Parent := Self;
    PomGrupa.OnCaptionClick := Self.CaptionClick;
    pomGrupa.MyCaption.Tekst := XMLGrupa.Nodes[i].ChildNodes.nodes['naziv'].NodeValue;
    DodajElemente(XMLGrupa.Nodes[i].ChildNodes.nodes['stavke'].ChildNodes, pomGrupa);
    Self.AddGrupu(pomGrupa);
  end;
end;

procedure TCSMPGroupBar.LoadFromXML(FileName: TFileName);
var
  XMLDoc: TXMLDocument;
begin
  XMLDoc := TXMLDocument.Create(self);
  XMLDoc.LoadFromFile(FileName);
  XMLDoc.Active := True;
  DodajGrupu(XMLDoc.DocumentElement.ChildNodes.Nodes['grupe'].ChildNodes);
  XMLDoc.Free;
end;

end.


