unit CSMPInspektor;

interface

uses
  Windows,SysUtils, Classes, Controls, Grids, Forms, Graphics, ExtCtrls,
  Buttons, StdCtrls, ComCtrls, Dialogs, Math,
  CSMPBlok, CSMPDugme, CSMPSplit, CSMPRadnaPovrsina, unVeza;

type

  TCSMPGrid = class(TStringGrid)
  public
    constructor Create(AOwner: TComponent); override;
    procedure Resize; override;
    procedure Ocisti;
    procedure SelektovanaCelija(Sender: TObject; Col, Row: Longint; var CanSelect: Boolean);
  end;

  TCSMPInspektor = class(TPanel)
  private
    SelektujemSpolja: boolean;
    FCaption: TCaption;
    FAktivnaPovrsina: TCSMPRadnaPovrsina;

    procedure SetCaption(const Value: TCaption);
    procedure SetAktivnaPovrsina(const Value: TCSMPRadnaPovrsina);

  protected
    DBlokovi: TCSMPDugme;// Dugme za blokove
    DElem: TCSMPDugme;   // Dugme za element
    DUlazi: TCSMPDugme;  // Dugme za ulaze/parametre
    DIzlazi: TCSMPDugme; // Dugme za izlaze

    PBPanel: TPanel;     // Panel koji drzi listview
    PEPanel: TPanel;     // Panel koji drzi elemente
    PUPanel: TPanel;     // Panel za ulaze/parametre
    PIPanel: TPanel;     // Panel za izlaze

    Splitter1: TCSMPSplit;
    Splitter2: TCSMPSplit;
    ListView1: TListView;
    AktivanBlok: TCSMPBlok;

    procedure LVSelektuj(Sender: TObject; Item: TListItem; Selected: Boolean);

  public
    SGUlazi: TCSMPGrid;   // Tabela za ulaze/parametre
    SGIzlazi: TCSMPGrid;  // Tabela za izlaze

    constructor Create(AOwner: TComponent); override;
    procedure Resize; override;

    procedure OsveziListu(Sender:TObject);
    procedure SelektujUListi(Sender:TObject);
    procedure Osvezi(Sender: TObject);
    procedure Popuni(Blok: TCSMPBlok);
    procedure Klik(Sender: TObject);
    procedure ProveraUnosa(Sender: TObject; ACol, ARow: Longint; const Value: string);

  published
    property Caption: TCaption read FCaption write SetCaption;
    property AktivnaPovrsina: TCSMPRadnaPovrsina
      read FAktivnaPovrsina write SetAktivnaPovrsina;
  end;

procedure Register;

implementation

var
  FS: TFormatSettings;

procedure Register;
begin
  RegisterComponents('CSMP', [TCSMPInspektor]);
end;

{ TCSMPGrid }

procedure TCSMPGrid.Ocisti;
var
  i: byte;
begin
  for i:=0 to RowCount-1 do
    Cells[1, i] := '';
  RowCount := 1;
  Cells[0, 0] := '';
end;

constructor TCSMPGrid.Create(AOwner: TComponent);
begin
  inherited;

  Left := 17;
  Top := 0;
  Width := 220;
  Height := 126;
  Align := alClient;
  BorderStyle := bsNone;
  Color := clWhite;
  ColCount := 2;
  RowCount:=0;
  Constraints.MinHeight := 50;
  DefaultColWidth := 98;
  DefaultRowHeight := 18;
  DefaultRowHeight := 18;
  FixedCols := 1;
  FixedRows := 0;
  Options := [goFixedVertLine, goFixedHorzLine, goVertLine, goHorzLine, goRangeSelect, goEditing, goTabs];
  ScrollBars := ssVertical;

end;

procedure TCSMPGrid.Resize;
begin
  inherited;
  if (Width mod self.ColCount) = 0 then
    DefaultColWidth := (Width-2) div self.ColCount
  else
    DefaultColWidth := (Width div self.ColCount)-1;
end;

{ TCSMPInspektor }

constructor TCSMPInspektor.Create(AOwner: TComponent);
var VPanel1: TPanel;  // mali panel na vrhu
    LVPanel1: TPanel; // panel iznad ListView-a
    LVPanel2: TPanel; // panel levo od ListView-a
    EPanel1: TPanel;  // panel levo od tabela ulaza i izlaza
    EPanel: TPanel;   // panel koji drzi elemente

begin
  inherited;
  FS.DecimalSeparator := '.';

  SelektujemSpolja := False;
  Left := 544;
  Top := 0;
  Width := 239;
  Height := 580;
  Align := alClient;
  BevelOuter := bvNone;
  Color := clBtnFace;
  AktivanBlok := nil;

  PBPanel := TPanel.Create(self);
  with PBPanel do
  begin
    parent := Self;
    Left := 0;
    Top := 26;
    Width := 239;
    Height := 166;
    Align := alTop;
    BevelOuter := bvNone;
    Constraints.MaxHeight := 246;
  end;

  VPanel1 := TPanel.Create(self);
  with VPanel1 do
  begin
    parent := Self;
    Left := 0;
    Top := 0;
    Width := 239;
    Height := 2;
    Align := alTop;
    BevelOuter := bvNone;
    Color := clBtnFace;
  end;

  ListView1 := TListView.Create(PBPanel);
  with ListView1 do
  begin
    Parent := PBPanel;
    Left := 17;
    Top := 18;
    Width := 190;
    Height := 148;
    Align := alClient;
    BorderStyle := bsNone;
    Color := clWhite;
    Columns.Add.Width := 190;
    Font.Charset := DEFAULT_CHARSET;
    Font.Color := clWindowText;
    Font.Height := -11;
    Font.Name := 'Verdana';
    Font.Style := [fsBold];
    FlatScrollBars := True;
    GridLines := True;
    RowSelect := True;
    ParentFont := False;
    ShowColumnHeaders := False;
    ViewStyle := vsReport;
    Constraints.MinHeight := 30;
    OnSelectItem := LVSelektuj;
    ReadOnly := True;
  end;

  LVPanel1 := TPanel.Create(PBPanel);
  with LVPanel1 do
  begin
    Parent:=PBPanel;
    Left := 0;
    Top := 0;
    Width := 239;
    Height := 18;
    Align := alTop;
    Alignment := taLeftJustify;
    BevelInner := bvRaised;
    BevelOuter := bvLowered;
    Color := clBtnFace;
    Font.Charset := DEFAULT_CHARSET;
    Font.Color := clWindowText;
    Font.Height := -11;
    Font.Name := 'Verdana';
    Font.Style := [fsBold];
    ParentFont := False;
    TabOrder := 2;
  end;

  LVPanel2 := TPanel.Create(PBPanel);
  with LVPanel2 do
  begin
    Parent:=PBPanel;
    Left := 0;
    Top := 18;
    Width := 17;
    Height := 148;
    Align := alLeft;
    BevelInner := bvRaised;
    BevelOuter := bvLowered;
    Color := clBtnFace;
  end;

  Splitter1 := TCSMPSplit.Create(Self);
  with Splitter1 do
  begin
    Parent := Self;
    Top := 192;
    Height := 8;
    Cursor := crVSplit;
    Beveled := True;
    Align := alTop;
    Color := clBtnFace;
    ParentColor := False;
    BojaTastera := clBtnFace;
    AktivniPanel := PBPanel;
  end;

  DBlokovi := TCSMPDugme.Create(Self);
  with DBlokovi do
  begin
    Parent := Self;
    AktivniPanel:=PBPanel;
    Left := 0;
    Top := 2;
    Width := 239;
    Height := 20;
    Align := alTop;
    Tekst := 'Blokovi';
    Font.Charset := DEFAULT_CHARSET;
    Font.Color := clWindowText;
    Font.Height := -11;
    Font.Name := 'Verdana';
    Font.Style := [fsBold];
    ParentFont := False;
    OnClick:=Klik;
  end;

  PEPanel := TPanel.Create(Self);
  with PEPanel do
  begin
    Parent := Self;
    Left := 0;
    Top := 218;
    Width := 239;
    Height := 362;
    Align := alClient;
    Color := clBtnFace;
    BevelInner := bvNone;
    BevelOuter := bvNone;
  end;

  DElem := TCSMPDugme.Create(Self);
  with DElem do
  begin
    Parent := Self;
    AktivniPanel := PEPanel;
    Left := 0;
    Top := 194;
    Width := 239;
    Height := 20;
    Align := alTop;
    Tekst := 'Naziv elementa';
    Font.Charset := DEFAULT_CHARSET;
    Font.Color := clWindowText;
    Font.Height := -11;
    Font.Name := 'Verdana';
    Font.Style := [fsBold];
    ParentFont := False;
    OnClick := Klik;
  end;

  EPanel := TPanel.Create(PEPanel);
  with EPanel do
  begin
    Parent := PEPanel;
    Align := alClient;
    Color := clWhite;
    BevelInner := bvNone;
    BevelOuter := bvNone;
  end;

  EPanel1 := TPanel.Create(PEPanel);
  with EPanel1 do
  begin
    Parent := PEPanel;
    Left := 0;
    Top := 0;
    Width := 17;
    Height := 126;
    Align := alLeft;
    BevelInner := bvRaised;
    BevelOuter := bvLowered;
    Color := clBtnFace;
  end;

  PUPanel := TPanel.Create(EPanel);
  with PUPanel do
  begin
    Parent := EPanel;
    Left := 1;
    Top := 19;
    Width := 237;
    Height := 126;
    Align := alTop;
    BevelOuter := bvNone;
    Color := clBtnFace;
    Constraints.MaxHeight := 180;
    Constraints.MinWidth := 110;
  end;

  SGUlazi := TCSMPGrid.Create(PUPanel);
  with SGUlazi do
  begin
    Parent := PUPanel;
    Ctl3D := False;
    OnSelectCell := SelektovanaCelija;
    OnSetEditText := ProveraUnosa;
  end;

  Splitter2 := TCSMPSplit.Create(EPanel);
  with Splitter2 do
  begin
    Parent := EPanel;
    Top := 100;
    Height := 8;
    Cursor := crVSplit;
    Align := alTop;
    Color := clBtnFace;
    ParentColor := False;
    BojaTastera := clBtnFace;
    AktivniPanel := PUpanel;
  end;

  DUlazi := TCSMPDugme.Create(EPanel);
  with DUlazi do
  begin
    Parent := EPanel;
    AktivniPanel := PUPanel;
    Left := 1;
    Top := 1;
    Width := 237;
    Height := 20;
    Align := alTop;
    Alignment := taLeftJustify;
    Tekst := 'Ulazi/Parametri';
    Color := clBtnFace;
    Font.Charset := DEFAULT_CHARSET;
    Font.Color := clWindowText;
    Font.Height := -11;
    Font.Name := 'Verdana';
    Font.Style := [fsBold];
    ParentFont := False;
    OnClick := Klik;
  end;

  PIPanel := TPanel.Create(EPanel);
  with PIPanel do
  begin
    Parent := EPanel;
    Left := 1;
    Top := 165;
    Width := 237;
    Height := 196;
    Align := alClient;
    BevelOuter := bvNone;
    Color := clBtnFace;
  end;

  SGIzlazi := TCSMPGrid.Create(PIPanel);
  SGIzlazi.Ctl3D := false;
  SGIzlazi.Parent := PIPanel;
  SGIzlazi.Enabled := False;

  DIzlazi := TCSMPDugme.Create(EPanel);
  with DIzlazi do
  begin
    Parent := EPanel;
    AktivniPanel := PIPanel;
    Left := 1;
    Top := 147;
    Width := 237;
    Height := 20;
    Align := alTop;
    Alignment := taLeftJustify;
    Tekst := 'Izlazi';
    Color := clBtnFace;

    Font.Charset := DEFAULT_CHARSET;
    Font.Color := clWindowText;
    Font.Height := -11;
    Font.Name := 'Verdana';
    Font.Style := [fsBold];
    ParentFont := False;
    OnClick := Klik;
  end;

  Popuni(nil);
end;

procedure TCSMPInspektor.Klik(Sender: TObject);
begin
  TCSMPDugme(Sender).AktivniPanel.Visible := not TCSMPDugme(Sender).AktivniPanel.Visible;
end;

procedure TCSMPInspektor.LVSelektuj(Sender: TObject; Item: TListItem;
  Selected: Boolean);
begin
  if ((not SelektujemSpolja) and Selected) then
    if (Item.Data <> nil) then
      TCSMPBlok(Item.Data).Aktivno := True;
end;

procedure TCSMPInspektor.Osvezi(Sender: TObject);
begin
  if (Sender is TCSMPBlok) and (Sender <> nil) then
    DElem.Tekst := IntToStr(TCSMPBlok(Sender).LokalniBroj)+'. '+TCSMPBlok(Sender).Naziv;
end;

procedure TCSMPInspektor.OsveziListu(Sender: TObject);
var
  pomli: TListItem;
  i: integer;
begin
  ListView1.Items.Clear;
  if AktivnaPovrsina.Visible then
    for i:=0 to AktivnaPovrsina.ComponentCount-1 do
      if (AktivnaPovrsina.Components[i] is TCSMPBlok) then
      begin
        pomli := ListView1.Items.Add;
        pomli.Data := TCSMPBlok(AktivnaPovrsina.Components[i]);
        pomli.Caption := IntToStr(TCSMPBlok(AktivnaPovrsina.Components[i]).LokalniBroj)+'. '+
                                  TCSMPBlok(AktivnaPovrsina.Components[i]).Naziv;
      end;
end;

procedure TCSMPInspektor.Popuni(Blok: TCSMPBlok);
var
  GridRect: TGridRect;
  i: integer;
  PomBlok: TCSMPBlok;

begin
  if ((AktivnaPovrsina <> nil) and AktivnaPovrsina.Visible) then
  begin
    AktivanBlok := Blok;
    SelektujUListi(AktivnaPovrsina);

    SGUlazi.Ocisti;
    SGIzlazi.Ocisti;

    if (Blok <> nil) then
    begin
      DElem.Tekst := IntToStr(Blok.LokalniBroj)+'. ' + Blok.Naziv;
      with SGUlazi, Blok do
      begin
        RowCount := 0;
        SGUlazi.Enabled := True;

        for i:=0 to 2 do
          if ((Nazivi[i+3] <> 'x')and(Nazivi[i+3] <> '')) then
          begin
            Cells[0, RowCount-1] := Nazivi[i+3];
            if (UlazneVeze.Items[i] <> nil) then
              Cells[1, RowCount-1] := IntToStr(VratiUlaz(i).LokalniBroj)
                                       + '. '+ VratiUlaz(i).Naziv
            else
              Cells[1, RowCount-1] := '<nema ulaza>';
            RowCount := RowCount + 1;
          end;


        if ((Nazivi[0] <> 'x')and(Nazivi[0] <> '')) then
        begin
          Cells[0, RowCount-1] := Nazivi[0];
          Cells[1, RowCount-1] := FloatToStr(ParI, FS);
          RowCount := RowCount+1;
        end;

        if ((Nazivi[1] <> 'x')and(Nazivi[1] <> '')) then
        begin
          Cells[0, RowCount-1] := Nazivi[1];
          Cells[1, RowCount-1] := FloatToStr(ParII, FS);
          RowCount := RowCount+1;
        end;

        if ((Nazivi[2] <> 'x')and(Nazivi[2] <> '')) then
        begin
          Cells[0, RowCount-1] := Nazivi[2];
          Cells[1, RowCount-1] := FloatToStr(ParIII, FS);
          RowCount := RowCount+1;
        end;

        RowCount := RowCount-1;

        GridRect.Left := 1;
        GridRect.Top := RowCount;
        GridRect.Right := 1;
        GridRect.Bottom := RowCount;
        Selection := GridRect;
      end;

      with SGIzlazi do
      begin
        if (Blok.IzlazneVeze.Count = 0) then
        begin
          Cells[0, 0] := 'Izlaz';
          Cells[1, 0] := '<nema izlaza>';
        end
        else
          for i := 0 to Blok.IzlazneVeze.Count-1 do
          begin
            RowCount := i+1;
            Cells[0, i] := 'Izlaz ' + IntToStr(i+1);
            PomBlok := TCSMPBlok(TVeza(Blok.IzlazneVeze.Items[i]).KrajBlok);
            Cells[1, i] := IntToStr(PomBlok.LokalniBroj) + '. ' + PomBlok.Naziv;
          end;

        GridRect.Left := 1;
        GridRect.Top := RowCount;
        GridRect.Right := 1;
        GridRect.Bottom := RowCount;
        Selection := GridRect;
      end;
    end
    else
    begin
      DElem.Tekst := 'CSMPInspector';
      SGUlazi.Enabled := False;
    end;
  end;
end;

procedure TCSMPInspektor.ProveraUnosa(Sender: TObject; ACol, ARow: Integer;
  const Value: string);
var
  Vrednost: real;
  Pom: integer;
begin
  if (Value <> '') then
  begin
    if ((Value = '-') or (Value = '+')) then exit;

    Vrednost := StrToFloatDef(Value, MaxInt, FS);
    if (Vrednost = MaxInt) then
    begin
      MessageDlg('Parametar mora biti realan broj!', mtError, [mbOK], 0);
      Self.SGUlazi.Cells[ACol, ARow] := '0';
    end
    else
      if (AktivanBlok <> nil) then
      begin
        Pom := ARow - AktivanBlok.MaxUlaznihVeza;
        case Pom of
          0: AktivanBlok.ParI := Vrednost;
          1: AktivanBlok.ParII := Vrednost;
          2: AktivanBlok.ParIII := Vrednost;
        end
      end;
  end;

end;

procedure TCSMPInspektor.Resize;
begin
  inherited;
  ListView1.Column[0].Width := ListView1.ClientWidth;
end;

procedure TCSMPInspektor.SelektujUListi(Sender: TObject);
var
  i: integer;

begin
  SelektujemSpolja := True;
  if ((Sender is TCSMPRadnaPovrsina) and (PBPanel.Visible)) then
    if (AktivnaPovrsina.SelektovanBlok <> nil) then
    begin
      for i:=0 to ListView1.Items.Count-1 do
        if TCSMPBlok(ListView1.Items.Item[i].Data) = AktivnaPovrsina.SelektovanBlok then
        begin
          ListView1.SetFocus;
          ListView1.Selected := ListView1.Items[i];
          ListView1.Selected.Focused := True;
          DElem.Tekst := ListView1.Items[i].Caption;
          break;
        end;
    end
    else
    begin
      if (ListView1.Selected <> nil) then
        ListView1.Selected.Focused := False;
      ListView1.Selected := nil;
      DElem.Tekst := ' ';
    end;

  SelektujemSpolja := False;
end;

procedure TCSMPInspektor.SetAktivnaPovrsina(const Value: TCSMPRadnaPovrsina);
begin
  if (FAktivnaPovrsina <> Value) then
    FAktivnaPovrsina := Value;
end;

procedure TCSMPInspektor.SetCaption(const Value: TCaption);
begin
  FCaption := Value;
end;

procedure TCSMPGrid.SelektovanaCelija(Sender: TObject; Col, Row: Integer;
  var CanSelect: Boolean);
begin
  CanSelect := ( StrToFloatDef(Self.Cells[Col, Row], MaxInt, FS) <> MaxInt);
end;

end.
