unit CSMPRadnaPovrsina;

interface

uses
  Windows, Forms, Messages, SysUtils, StdCtrls, Classes, Controls, ExtCtrls,
  Graphics, Dialogs, Types, Skroler, Buttons, unDrzac,unVeza, CSMPBlok, XMLIntf, XMLDoc;

type
  TRPStanje = (rpsSelektuj, rpsDodajDrzac, rpsDodajVezuEx, rpsKreirajJunctionEx, rpsBrisem);

  TCSMPRadnaPovrsina = class(TCustomControl)
  private
    FSelektovanBlok: TCSMPBlok;
    FOnSelectBlok: TNotifyEvent;
    FSlikeDesno: TImageList;
    FSlikeDole: TImageList;
    FSlikeLevo: TImageList;
    FSlikeGore: TImageList;

    FDrzaci: TImageList;
    FStanje: TRPStanje;
    FOnStanjeChange: TNotifyEvent;
    FSelektovanaVeza: TVeza;
    FOnChange: TNotifyEvent;
    FSelektovanDrzac: TDrzac;
    FGridSlika: TBitmap;
    FOnDropBlok: TNotifyEvent;
    FOnPoveziVezu: TNotifyEvent;
    FOnBrisiBlok: TNotifyEvent;

    procedure VezaDesniKlik(Sender: TObject);
    procedure BlokMouseMove(Sender: Tobject);
    procedure BlokClick(Sender: TObject);
    procedure SetSelektovanBlok(const Value: TCSMPBlok);
    procedure SetOnSelectBlok(const Value: TNotifyEvent);
    procedure SetSlikeDesno(const Value: TImageList);
    procedure SetSlikeDole(const Value: TImageList);
    procedure SetSlikeGore(const Value: TImageList);
    procedure SetSlikeLevo(const Value: TImageList);

    procedure SetDrzaci(const Value: TImageList);
    procedure SetStanje(const Value: TRPStanje);
    procedure SetOnStanjeChange(const Value: TNotifyEvent);
    procedure DrzacKreiran(Sender: TObject);
    procedure SetSelektovanaVeza(const Value: TVeza);
    procedure SetOnChange(const Value: TNotifyEvent);
    procedure BrisiDrzac(Sender: TObject);
    procedure PomerajMisa(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure SetOnDropBlok(const Value: TNotifyEvent);
    procedure SetOnPoveziVezu(const Value: TNotifyEvent);
    procedure SetOnBrisiBlok(const Value: TNotifyEvent);

  protected
    procedure DeselektujVezu(Sender: TObject);
    procedure SelektujVezu(Sender: TObject);
    procedure KeyDown(var Key: Word; Shift: TShiftState);override;
    function NadjiKrajBlok(uVeza:TVeza): TCSMPBlok;

  public
    Veze: TList;
    TempIzlaz: TCSMPBlok;
    TempUlaz: TCSMPBlok;
    TempVeza: TVeza;

    TempDinV: TVeza;
    TempDinBS: TCSMPBlok;
    TempDinD: TDrzac;
    OpisProblema: string;

    procedure Paint;override;
    procedure SelektujDrzac(Sender: TObject);
    procedure DeselektujDrzac(Sender: TObject);
    procedure SelektujJunction(Sender: TObject);
    procedure DeSelektujJunction(Sender: TObject);
    procedure OdrediBrojeve;
    procedure ObrisiDrzac(d: TDrzac);
    procedure ObrisiVeze(uVeze: TList);
    procedure ObrisiVezu(Veza:TVeza);
    procedure ObrisiBlok(uBlok: TCSMPBlok);
    procedure DragDrop(Source: TObject; X, Y: Integer); override;
    procedure DragOver(Source: TObject; X, Y: Integer; State: TDragState;
      var Accept: Boolean); override;
    constructor Create(AOwner:TComponent);override;
    destructor Destroy;override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure Aktivacija(Sender:TObject);
    procedure ObrisiSelektovano;

    procedure SaveToFile(FileName:string);
    procedure LoadFromFile(Filename:string);

    function  NadjiBlok(lb:integer):TCSMPBlok;

    procedure ObrisiSve;

    procedure SacuvajVezu(Koren:IXMLNode;Veza:TVeza);
    procedure SacuvajJunction(Koren:IXMLNode;Veza:TVeza);

    procedure UcitajVezu(Koren:IXMLNode;var Veza:TVeza);
    procedure UcitajJunction(Koren:IXMLNode;var Veza:TVeza;drz:TDrzac);
    procedure UcitajDrzac(Koren:IXMLNode;var Veza:TVeza);

    property SelektovanBlok: TCSMPBlok read FSelektovanBlok write SetSelektovanBlok;
    property SelektovanaVeza: TVeza read FSelektovanaVeza write SetSelektovanaVeza;

  published
    property SlikeLevo:TImageList read FSlikeLevo write SetSlikeLevo;
    property SlikeDesno:TImageList read FSlikeDesno write SetSlikeDesno;
    property SlikeGore:TImageList read FSlikeGore write SetSlikeGore;
    property SlikeDole:TImageList read FSlikeDole write SetSlikeDole;
    property Drzaci:TImageList read FDrzaci write SetDrzaci;
    property Align default alClient;
    property Color default clWhite;
    property Stanje: TRPStanje read FStanje write SetStanje;
    property OnSelectBlok: TNotifyEvent read FOnSelectBlok write SetOnSelectBlok;
    property OnStanjeChange: TNotifyEvent read FOnStanjeChange write SetOnStanjeChange;
    property OnChange: TNotifyEvent read FOnChange write SetOnChange;
    property OnDropBlok: TNotifyEvent read FOnDropBlok write SetOnDropBlok;
    property OnPoveziVezu: TNotifyEvent read FOnPoveziVezu write SetOnPoveziVezu;
    property OnBrisiBlok: TNotifyEvent read FOnBrisiBlok write SetOnBrisiBlok;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('CSMP', [TCSMPRadnaPovrsina]);
end;

{ TCSMPRadnaPovrsina }

procedure TCSMPRadnaPovrsina.BrisiDrzac(Sender: TObject);
var j: Integer;
  l: TList;
begin
  if Sender is TDrzac then
  begin
    l := TDrzac(Sender).GetJunctionList;
    if l <> nil then
      for j := 0 to l.Count - 1 do
        ObrisiVezu(TVeza(l.items[j]));
  end;

  if Assigned(OnChange) then
    OnChange(Self);

end;

procedure TCSMPRadnaPovrsina.Aktivacija(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to ComponentCount - 1 do
    if (Components[i] is TCSMPBlok) then
    begin
      if (TCSMPBlok(Components[i]) <> TCSMPBlok(Sender)) then
        TCSMPBlok(Components[i]).Aktivno := False;

      SelektovanBlok := TCSMPBlok(Sender);
    end;

  if (Sender <> nil) then
    SelektujVezu(nil);

  if Visible then TForm(Owner).ActiveControl := Self;
end;

constructor TCSMPRadnaPovrsina.Create(AOwner: TComponent);
begin
  inherited;
  FGridSlika := TBitmap.Create;
  FGridSlika.Height := 8;
  FGridSlika.Width := 8;
  FGridSlika.Canvas.Brush.Color := clWhite;
  FGridSlika.Canvas.Pen.Color := clWhite;
  FGridSlika.Canvas.Rectangle(0, 0, 8, 8);
  FGridSlika.Canvas.Pixels[0, 0] := clSilver;
  FGridSlika.Transparent := True;
  Canvas.Brush.Bitmap := FGridSlika;
  TempIzlaz := nil;
  TempUlaz := nil;
  TempVeza := nil;
  Veze := TList.Create;
  Stanje := rpsSelektuj;
  Align := alClient;
  Color := clWhite;
  SelektovanBlok := nil;
  TempDinV := nil;
  TempDinBS := nil;
  TempDinD := nil;
  Self.OnMouseMove := PomerajMisa;
end;

procedure TCSMPRadnaPovrsina.PomerajMisa(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var
  tep: TPoint;
begin
  if (TempDinV <> nil) then
  begin
    tep.X := x;
    tep.Y := y;
    TempDinV.SetEP(tep);
  end;
end;

procedure TCSMPRadnaPovrsina.SelektujJunction(Sender: TObject);
var
  i: integer;
begin
  for i := 0 to Veze.Count - 1 do
    if TVeza(Veze.Items[i]) is TVeza then
      if TVeza(Veze.Items[i]) <> TVeza(Sender) then TVeza(Veze.Items[i]).UnSelectAll;

  SelektovanaVeza := TVeza(Sender);
  FSelektovanDrzac := nil;
  if Sender <> nil then
    Aktivacija(nil);
end;

procedure TCSMPRadnaPovrsina.SelektujDrzac(Sender: TObject);
var
  i: integer;
begin
  if (Sender is TVeza) then
    for i := 0 to Veze.Count - 1 do
      if TVeza(Veze.Items[i]) is TVeza then
        if TVeza(Veze.Items[i]) <> TVeza(Sender) then
          TVeza(Veze.Items[i]).UnSelectAll;

  SelektovanaVeza := nil;
  FSelektovanDrzac := TVeza(Sender).GetSelectedDrzac;

  if (Sender is TVeza) and (self.Stanje = rpsKreirajJunctionEx) then
  begin
    TempDinD := TVeza(Sender).GetLastDrzac;
    TVeza(Sender).KreirajJunction(TempDinD.GetCentarXY);
    TempDinV := TVeza(TVeza(Sender).GetLastDrzac.GetJunctionList.Last);
    TempDinV.SetColor(clBlack);
    TempDinV.Selektovano := false;
    TempDinV.IsJunction := true;
    TempDinV.OnMouseClickEx := VezaDesniKlik;
    TempDinV.Stanje := stKreirajDrzac;
  end;

  if (Sender <> nil) then
    Aktivacija(nil);
end;

procedure TCSMPRadnaPovrsina.DeselektujVezu(Sender: TObject);
begin
  if TVeza(Sender) = SelektovanaVeza then
    SelektovanaVeza := nil;
end;

procedure TCSMPRadnaPovrsina.DeselektujDrzac(Sender: TObject);
begin
  FSelektovanDrzac := nil;
end;

procedure TCSMPRadnaPovrsina.DeselektujJunction(Sender: TObject);
begin
  SelektovanaVeza := nil;
end;

destructor TCSMPRadnaPovrsina.Destroy;
begin

  try
    ObrisiSve;
  except
    on e: Exception do
    begin
      ShowMessage('Neocekivana greska pri ciscenju povrsine');
    end;
  end;

  Canvas.Brush.Bitmap := nil;
  FGridSlika.Free;
  Veze.Pack;
  Veze.Free;
  inherited Destroy;
end;

procedure TCSMPRadnaPovrsina.BlokMouseMove(Sender: Tobject);
begin
  if ((self.Stanje = rpsDodajVezuEx) or (Self.Stanje = rpsKreirajJunctionEx)) and (TempDinV <> nil) then
    TempDinV.SetEP(TCSMPBlok(Sender).VratiUlaznuTacku(TempDinV));

end;

procedure TCSMPRadnaPovrsina.VezaDesniKlik(Sender: TObject);
begin
  if stanje = rpsKreirajjunctionEx then
    TempDinV.Parent.ObrisiDrzacM(TempDinV.Parent.GetLastDrzac);

  TempDinV.Free;
  TempDinV := nil;
  TempDinBS := nil;
  Self.Stanje := rpsSelektuj;
end;

procedure TCSMPRadnaPovrsina.BlokClick(Sender: Tobject);
begin
  if (Self.Stanje = rpsDodajVezuEx) then
  begin
    if (TempDinBS = nil) then
    begin
      if (TCSMPBlok(sender).IzlazneVeze.Count < 1) then
      begin
        TempDinBS := TCSMPBlok(sender);
        TempDinV := TVeza.Create(Drzaci, Self, TCSMPBlok(Sender).IzlaznaTacka, TCSMPBlok(Sender).IzlaznaTacka);
        TempDinV.OnChange := OnChange;
        TempDinV.Stanje := stKreirajDrzac;
        TempDinV.OnMouseClickEx := VezaDesniKlik;
      end
      else
        MessageDlg('Iz ovog bloka vec postoji izlaz!'+#13+
                   '    Koristite junction vezu!', mtError, [mbOK], 0);
    end
    else
    begin
      if TCSMPBlok(Sender) = TempDinBS then
      begin
        TempDinV.Free;
        TempDinBS := nil;
        TempDinV := nil;
        Stanje := rpsSelektuj;
        exit;
      end;

      TempDinV.OnBrisanjeI := TempDinBS.BrisiVezuI;
      TempDinV.OnBrisanjeU := TCSMPBlok(Sender).BrisiVezuU;

      TempDinV.PocBlok := TempDinBS;
      TempDinV.KrajBlok := TCSMPBlok(Sender);
      TempDinBs.DodajIVezu(TempDinV);

      TempDinV.DrzacKreiran := Drzackreiran;
      TempDinV.OnSelektVeza := SelektujVezu;
      TempDinV.OnDeselectVeza := DeselektujVezu;
      TempDinV.OnSelektDrzac := SelektujDrzac;
      TempDinV.OnDeselectDrzac := DeselektujDrzac;
      TempDinV.OnSelectJunction := SelektujJunction;
      TempDinV.OnDeSelectJunction := DeSelektujJunction;
      TempDinV.OnBrisiJunction := BrisiDrzac;
      TempDinV.OnDrzacFree := BrisiDrzac;
      TempDinV.Stanje := stNone;
      TempDinV.SetEP(TCSMPBLok(Sender).VratiUlaznuTacku(TempDinV));
      Veze.Add(TempDinV);

      if Assigned(OnPoveziVezu) then
          OnPoveziVezu(Self);

      TempDinBS := nil;
      TempDinV := nil;
      Stanje := rpsSelektuj;
    end;
  end
  else
    if ((Self.Stanje = rpsKreirajJunctionEx) and (TempDinV <> nil)) then
    begin
      TempDinV.PocBlok := NadjiKrajBlok(TempDinV);
      TempDinV.KrajBlok := TCSMPBlok(Sender);

      TempDinV.OnBrisanjeU := TCSMPBlok(Sender).BrisiVezuU;
      TempDinV.DrzacKreiran := Drzackreiran;
      TempDinV.OnSelektVeza := SelektujVezu;
      TempDinV.OnDeselectVeza := DeselektujVezu;
      TempDinV.OnSelektDrzac := SelektujDrzac;
      TempDinV.OnDeselectDrzac := DeselektujDrzac;
      TempDinV.OnSelectJunction := SelektujJunction;
      TempDinV.OnDeSelectJunction := DeSelektujJunction;
      TempDinV.OnDrzacFree := BrisiDrzac;
      TempDinV.OnBrisiJunction := BrisiDrzac;
      Veze.Add(TempDinV);
      TCSMPBlok(TempDinV.PocBlok).DodajIVezu(TempDinV);
      TempDinV.Stanje := stNone;

      if Assigned(OnPoveziVezu) then
          OnPoveziVezu(Self);

      TempDinBS := nil;
      TempDinV := nil;
      Stanje := rpsSelektuj;
    end
    else
      Stanje := rpsSelektuj;

//***********
  if Assigned(OnSelectBlok) then
    OnSelectBlok(Self);
end;

procedure TCSMPRadnaPovrsina.DragDrop(Source: TObject; X, Y: Integer);
var
  Blok: TCSMPBlok;
  i: byte;
begin
  Blok := TCSMPBlok.Create(Self);
  Blok.Visible := false;
  Blok.Parent := Self;
  Blok.OnAktiviran := Aktivacija;
  Blok.SlikeLevo := SlikeLevo;
  Blok.SlikeDesno := SlikeDesno;
  Blok.SlikeGore := SlikeGore;
  Blok.SlikeDole := SlikeDole;
  Blok.Smer := smDesno;
  Blok.Left := X;
  Blok.Top := Y;
  Blok.Naziv := TSkrolStavka(Source).Naziv;
  Blok.Hint := Blok.Naziv;
  Blok.ShowHint := True;
  Blok.ImageIndex := TSkrolStavka(Source).ImageIndex;
  Blok.MaxUlaznihVeza := TSkrolStavka(Source).MaxUlaznihVeza;
  Blok.BrojPar := TSkrolStavka(Source).BrojParam;
  Blok.OnBlokClick := BlokClick;
  Blok.OnBlokMouseMove := BlokMouseMove;
  Blok.Visible := True;
  Blok.Aktivno := True;
  Blok.Sifra := Blok.ImageIndex;
  Blok.OnChange := Self.OnChange;
  for i:=0 to 5 do
    Blok.Nazivi[i] := TSkrolStavka(Source).Nazivi[i];

  OdrediBrojeve;
  Self.Stanje := rpsSelektuj;
  
  if Assigned(OnChange) then
    OnChange(Self);

  if Assigned(OnDropBlok) then
    OnDropBlok(Self);
//******************
  if Assigned(OnSelectBlok) then
    OnSelectBlok(Self);

end;

procedure TCSMPRadnaPovrsina.DragOver(Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  inherited;
  if source is TSkrolStavka then
    Accept := True
  else
    Accept := False;
end;

procedure TCSMPRadnaPovrsina.DrzacKreiran(sender: TObject);
begin
  if not (self.Stanje in [ rpsDodajVezuEx, rpsKreirajJunctionEx ]) then
    self.Stanje := rpsSelektuj
  else
    if (Sender is TVeza) and (self.Stanje = rpsKreirajJunctionEx) then
    begin
      TempDinD := TVeza(Sender).GetLastDrzac;
      TVeza(Sender).KreirajJunction(TempDinD.GetCentarXY);
      TempDinV := TVeza(TVeza(Sender).GetLastDrzac.GetJunctionList.Last);
      TempDinV.SetColor(clBlack);
      TempDinV.Selektovano := false;
      TempDinV.IsJunction := true;
      TempDinV.OnMouseClickEx := VezaDesniKlik;
      TempDinV.Stanje := stKreirajDrzac;
    end;

  if Assigned(OnChange) then
    OnChange(Self);

end;

procedure TCSMPRadnaPovrsina.KeyDown(var Key: Word; Shift: TShiftState);
begin
  inherited;
  if key = VK_DELETE then
    ObrisiSelektovano;

end;

procedure TCSMPRadnaPovrsina.MouseDown(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  i: integer;
  tep: TPoint;
begin
  inherited;
  for i := 0 to self.ComponentCount - 1 do
    if (Components[i] is TCSMPBlok) then
      TCSMPBlok(Components[i]).aktivno := False;

  for i := 0 to Veze.Count - 1 do
    TVeza(Veze.Items[i]).UnSelectAll;

  Stanje := rpsSelektuj;

  SelektovanaVeza := nil;
  SelektovanBlok := nil;
  FSelektovanDrzac := nil;
  self.Enabled := True;
  tep.x := x;
  tep.y := y;
  if (TempDinV <> nil) then
    TempDinV.SetEP(tep);

end;

procedure TCSMPRadnaPovrsina.ObrisiBlok(uBlok: TCSMPBlok);
var
  i: integer;
  pomk: TCSMPBlok;

begin
  if uBlok = SelektovanBlok then
    SelektovanBlok := nil;

  pomk := nil;

  for i:=ComponentCount-1 downto 0 do
    if (Components[i] is TCSMPBlok) then
      if (TCSMPBlok(Components[i]) = uBlok) then
      begin
        pomk := TCSMPBlok(Components[i]);
        break;
      end;

  if (pomk <> nil) then
  begin
    ObrisiVeze(pomk.UlazneVeze);
    if (Stanje <> rpsBrisem) then
      ObrisiVeze(pomk.IzlazneVeze);

    pomk.Free;
  end;

  if (self.Stanje <> rpsBrisem) then
  begin
    self.OdrediBrojeve;
    if Assigned(OnChange) then
      OnChange(self);

  end;

  if Assigned(OnBrisiBlok) then
    OnBrisiBlok(Self);

end;

procedure TCSMPRadnaPovrsina.ObrisiSelektovano;
begin
  Stanje := rpsSelektuj;
  if (SelektovanBlok <> nil) then
  begin
    ObrisiBlok(SelektovanBlok);
    self.OdrediBrojeve;
  end;

  if (SelektovanaVeza <> nil) then
    ObrisiVezu(SelektovanaVeza);

  if (FSelektovanDrzac <> nil) then
    ObrisiDrzac(FSelektovanDrzac);

  if Assigned(OnChange) then
    OnChange(self);

  Stanje := rpsSelektuj;
end;

procedure TCSMPRadnaPovrsina.ObrisiDrzac(d: TDrzac);
var i: integer;
begin
  for i := 0 to Veze.Count - 1 do
    if TVeza(Veze.Items[i]) is TVeza then
      if TVeza(Veze.Items[i]).GetSelectedDrzac <> nil then
      begin
        TVeza(Veze.Items[i]).ObrisiSelektovanDrzac;
        break;
      end;

  if Assigned(OnChange) then
    OnChange(self);

end;

procedure TCSMPRadnaPovrsina.ObrisiVeze(uVeze: TList);
var
  pom: integer;
  pomv: TVeza;
  i, j: integer;

begin

  for j:=uVeze.Count-1 downto 0 do
  begin
    pomv := TVeza(uVeze.Items[j]);

    if (pomv = SelektovanaVeza) then
      SelektovanaVeza := nil;

    pom := Veze.IndexOf(pomv);
    if (pomv <> nil) then
      if pomv.IsJunction then
      begin
        // *** KOSTA 17.01.2004. ovo je linija koja je falila !!!!!!
        TCSMPBlok(pomv.PocBlok).BrisiVezuI(pomv);

        for i := 0 to Veze.Count - 1 do
          TVeza(Veze.Items[i]).DeleteJunction(pomv);
      end;

    if (pom <> -1) then
    begin
      Veze.Delete(pom);
      Veze.Pack;
    end;
    pomv.Free;
  end;
end;

procedure TCSMPRadnaPovrsina.ObrisiVezu(Veza: TVeza);
var
  pom: integer;
  pomv: TVeza;
  i, j: integer;
begin
  if Veza = SelektovanaVeza then
    SelektovanaVeza := nil;

  pom := Veze.IndexOf(Veza);
  if (pom <> -1) then
  begin
    pomv := TVeza(Veze.Items[pom]);
    for i:=(ComponentCount-1) downto 0 do
      if (Components[i] is TCSMPBlok) then
        with TCSMPBlok(Components[i]) do
        begin
          for j := 0 to UlazneVeze.Count - 1 do
            if (VratiUlaz(j) = TCSMPBlok(PomV.PocBlok)) then
            begin
              if not veza.IsJunction then
                BrisiVezuU(pomv);

              break;
            end;
          BrisiVezuI(pomv);
        end;

    if pomv.IsJunction then
      for i:=0 to Veze.Count - 1 do
        TVeza(Veze.Items[i]).DeleteJunction(pomv);

    pomv.Free;
    Veze.Delete(pom);
    Veze.Pack;

    if Assigned(OnChange) then
      OnChange(self);

  end;
end;

procedure TCSMPRadnaPovrsina.OdrediBrojeve;
var
  i, j: integer;

begin
  j := 0;
  for i := 0 to ComponentCount - 1 do
    if (Components[i] is TCSMPBlok) then
    begin
      inc(j);
      TCSMPBlok(Components[i]).LokalniBroj := j;
    end;
end;

procedure TCSMPRadnaPovrsina.Paint;
begin
  inherited;
  canvas.Brush.Bitmap := FGridSlika;
  canvas.FillRect(rect(1, 1, Width-1, Height-1));
end;

procedure TCSMPRadnaPovrsina.SelektujVezu(Sender: TObject);
var
  i: integer;
begin
  for i:=0 to Veze.Count-1 do
    if (TVeza(Veze.Items[i]) is TVeza) then
    begin
      if (TVeza(Veze.Items[i]) <> TVeza(Sender)) then
        TVeza(Veze.Items[i]).UnSelectAll;

      SelektovanaVeza := TVeza(Sender);
    end;

  FSelektovanDrzac := nil;
  if (Sender <> nil) then
    Aktivacija(nil);
end;

procedure TCSMPRadnaPovrsina.SetDrzaci(const Value: TImageList);
begin
  FDrzaci := Value;
end;

procedure TCSMPRadnaPovrsina.SetOnChange(const Value: TNotifyEvent);
begin
  FOnChange := Value;
end;

procedure TCSMPRadnaPovrsina.SetOnDropBlok(const Value: TNotifyEvent);
begin
  FOnDropBlok := Value;
end;

procedure TCSMPRadnaPovrsina.SetOnSelectBlok(const Value: TNotifyEvent);
begin
  FOnSelectBlok := Value;
end;

procedure TCSMPRadnaPovrsina.SetOnPoveziVezu(const Value: TNotifyEvent);
begin
  FOnPoveziVezu := Value;
end;

procedure TCSMPRadnaPovrsina.SetOnStanjeChange(const Value: TNotifyEvent);
begin
  FOnStanjeChange := Value;
end;

procedure TCSMPRadnaPovrsina.SetSelektovanaVeza(const Value: TVeza);
begin
  FSelektovanaVeza := Value;
end;

procedure TCSMPRadnaPovrsina.SetSelektovanBlok(const Value: TCSMPBlok);
begin
  if (FSelektovanBlok <> Value) then
  begin
    FSelektovanBlok := Value;
    if Assigned(OnSelectBlok) then
      OnSelectBlok(Self);
  end;
end;

procedure TCSMPRadnaPovrsina.SetSlikeDesno(const Value: TImageList);
begin
  FSlikeDesno := Value;
end;

procedure TCSMPRadnaPovrsina.SetSlikeDole(const Value: TImageList);
begin
  FSlikeDole := Value;
end;

procedure TCSMPRadnaPovrsina.SetSlikeGore(const Value: TImageList);
begin
  FSlikeGore := Value;
end;

procedure TCSMPRadnaPovrsina.SetSlikeLevo(const Value: TImageList);
begin
  FSlikeLevo := Value;
end;

procedure TCSMPRadnaPovrsina.SetStanje(const Value: TRPStanje);
var
  i: integer;
begin
  FStanje := Value;
  case Value of
    rpsSelektuj:
      begin
        for i := 0 to ComponentCount - 1 do
          if (Components[i] is TCSMPBlok) then
            TCSMPBlok(Components[i]).Stanje := stSelektujem;

        for i := 0 to Veze.Count - 1 do
          TVeza(Veze.Items[i]).Stanje := stNone;

        TempUlaz := nil;
        TempIzlaz := nil;
      end;
    rpsDodajVezuEx:
      begin
        for i := 0 to ComponentCount - 1 do
          if (Components[i] is TCSMPBlok) then
            TCSMPBlok(Components[i]).Stanje := stDodajemVezu;

        for i := 0 to Veze.Count - 1 do
          TVeza(Veze.Items[i]).Stanje := stNone;
      end;
    rpsKreirajJunctionEx:
      begin
        for i := 0 to ComponentCount - 1 do
          if (Components[i] is TCSMPBlok) then
            TCSMPBlok(Components[i]).Stanje := stKreiramJunction;

        for i := 0 to Veze.Count - 1 do
          TVeza(Veze.Items[i]).Stanje := stPripremiZaJunction;
      end;
    rpsDodajDrzac:
      begin
        for i := 0 to ComponentCount - 1 do
          if (Components[i] is TCSMPBlok) then
            TCSMPBlok(Components[i]).Stanje := stSelektujem;

        for i := 0 to Veze.Count - 1 do
          TVeza(Veze.Items[i]).Stanje := stKreirajDrzac;
      end;
  end;

  if Assigned(OnStanjeChange) then
    OnStanjeChange(Self);
end;

function TCSMPRadnaPovrsina.NadjiKrajBlok(uVeza: TVeza): TCSMPBlok;
begin
  if uVeza.IsJunction then
    Result := NadjiKrajBlok(uVeza.parent)
  else
    Result := TCSMPBlok(uVeza.PocBlok);
end;

procedure TCSMPRadnaPovrsina.SaveToFile(FileName: string);
var
  XMLDoc: TXMLDocument;
  XMLKoren: IXMLNode;
  pom: IXMLNode;
  i: integer;

begin
  XMLDoc := TXMLDocument.Create(self);
  XMLDoc.Active := True;
  XMLDoc.Version := '1.0';
  XMLKoren := XMLDoc.AddChild('CSMPDokument');
  pom := XMLKoren.AddChild('OpisProblema');
  pom.Text := OpisProblema;
  pom := XMLKoren.AddChild('Blokovi');

  for i := 0 to ComponentCount - 1 do
    if (Components[i] is TCSMPBlok) then
      TCSMPBlok(Components[i]).Save(pom);

  pom := XMLKoren.AddChild('Veze');
  for i := 0 to Veze.Count - 1 do
    if not TVeza(Veze.Items[i]).IsJunction then
      SacuvajVezu(pom, TVeza(Veze.Items[i]));

  XMLDoc.SaveToFile(FileName);
  XMLDoc.Free;
end;

procedure TCSMPRadnaPovrsina.LoadFromFile(Filename: string);
var
  XMLDoc: TXMLDocument;
  XMLKoren: IXMLNode;
  pom: IXMLNode;
  blok: TCSMPBlok;
  pomvv: TVeza;
  i: integer;

begin
  ObrisiSve;
  Visible := False;
  XMLDoc := TXMLDocument.Create(self);
  XMLDoc.LoadFromFile(FileName);
  XMLDoc.Active := True;
  XMLKoren := XMLDoc.DocumentElement;

  OpisProblema := XMLKoren.ChildNodes.Nodes['OpisProblema'].Text;
  pom := XMLKoren.ChildNodes.Nodes['Blokovi'];
  for i := 0 to pom.ChildNodes.Count - 1 do
  begin
    Blok := TCSMPBlok.Create(self);
    Blok.Visible := False;
    Blok.Parent := Self;
    Blok.OnAktiviran := Aktivacija;
    Blok.SlikeLevo := SlikeLevo;
    Blok.SlikeDesno := SlikeDesno;
    Blok.SlikeGore := SlikeGore;
    Blok.SlikeDole := SlikeDole;
    Blok.Load(pom.ChildNodes.Nodes[i]);
    Blok.Hint := Blok.Naziv;
    Blok.ShowHint := True;
    Blok.ImageIndex := Blok.Sifra;
    Blok.OnBlokClick := BlokClick;
    Blok.OnBlokMouseMove := BlokMouseMove;
    Blok.Visible := True;
    Blok.Aktivno := True;
    Blok.OnChange := Self.OnChange;
  end;

  pom := XMLKoren.ChildNodes.Nodes['Veze'];
  Veze.Clear;

  for i := 0 to pom.ChildNodes.Count - 1 do
  begin
    UcitajVezu(pom.ChildNodes.Nodes[i], pomvv);
    Veze.Add(pomvv);
  end;

  OdrediBrojeve;
  if Assigned(OnStanjeChange) then
    OnStanjeChange(self);

  Visible := True;  
  XMLDoc.Free;
end;

procedure TCSMPRadnaPovrsina.ObrisiSve;
var
  i: integer;

begin
  try
    Stanje := rpsBrisem;
    Visible := False;

    for i:=ComponentCount-1 downto 0 do
      if (Components[i] is TCSMPBlok) then
        with TCSMPBlok(Components[i]) do
        begin
          IzlazneVeze.clear;
          UlazneVeze.clear;
          Free;
        end;

    Veze.Pack;
    while (Veze.Count > 0) do
      ObrisiVezu(TVeza(Veze.Items[0]));

  finally
    Visible := True;
    Stanje := rpsSelektuj;
  end;
end;

procedure TCSMPRadnaPovrsina.SacuvajVezu(Koren: IXMLNode;Veza:TVeza);
var
  pom, pom2: IXMLNode;
  pom3, pom4: IXMLNode;
  i, j: integer;
  poml: TList;
  pomint: integer;

begin
  pom := Koren.AddChild('Veza');
  pom2 := pom.AddChild('PocBlok');
  pom2.Text := inttostr(TCSMPBlok(Veza.PocBlok).LokalniBroj);

  pom2 := pom.AddChild('KrajBlok');
  pom2.Text := inttostr(TCSMPBlok(Veza.KrajBlok).LokalniBroj);

  pomint := TCSMPBlok(Veza.KrajBlok).GdeUBloku(Veza);
  if pomint > -1 then
  begin
    pom2 := pom.AddChild('GdeKrajBlok');
    pom2.Text := inttostr(pomint);
  end
  else
    raise Exception.Create('Neocekivana greska kod snimanja veze!!!');

  pom2 := pom.AddChild('Drzaci');

  for i := 0 to Veza.LDrzaca.Count - 1 do
  begin
    pom3 := pom2.AddChild('Drzac');
    pom4 := pom3.AddChild('Top');
    pom4.Text := inttostr(TDrzac(Veza.LDrzaca.Items[i]).Top);
    pom4 := pom3.AddChild('Left');
    pom4.Text := inttostr(TDrzac(Veza.LDrzaca.Items[i]).Left);

    pom4 := pom3.AddChild('Index');
    pom4.Text := inttostr(i);

    poml := TDrzac(Veza.LDrzaca.Items[i]).GetJunctionList;
    pom4 := pom3.AddChild('Junctions');
    if (poml <> nil) then
      for j := 0 to poml.Count - 1 do
        SacuvajJunction(pom4, TVeza(poml.items[j]));

  end;
end;

procedure TCSMPRadnaPovrsina.SacuvajJunction(Koren: IXMLNode; Veza: TVeza);
var
  pom, pom2: IXMLNode;
  pom3, pom4: IXMLNode;
  i, j: integer;
  poml: TList;
  pomint: integer;
begin
  pom := Koren.AddChild('Junction');
  pom2 := pom.AddChild('PocBlok');
  pom2.Text := IntToStr( TCSMPBlok(Veza.PocBlok).LokalniBroj );
  pom2 := pom.AddChild('KrajBlok');
  pom2.Text := IntToStr( TCSMPBlok(Veza.KrajBlok).LokalniBroj );

  pomint := TCSMPBlok(Veza.KrajBlok).GdeUBloku(Veza);
  if (pomint > -1) then
  begin
    pom2 := pom.AddChild('GdeKrajBlok');
    pom2.Text := IntToStr(pomint);
  end
  else
    raise Exception.Create('Neocekivana greska kod snimanja junction veze!!!');

  pom2 := pom.AddChild('Drzaci');
  for i:=0 to Veza.LDrzaca.Count-1 do
  begin
    pom3 := pom2.AddChild('Drzac');
    pom4 := pom3.AddChild('Top');
    pom4.Text := IntToStr( TDrzac(Veza.LDrzaca.Items[i]).Top );
    pom4 := pom3.AddChild('Left');
    pom4.Text := IntToStr( TDrzac(Veza.LDrzaca.Items[i]).Left );
    pom4 := pom3.AddChild('Index');
    pom4.Text := IntToStr(i);

    poml := TDrzac(Veza.LDrzaca.Items[i]).GetJunctionList;
    pom4 := pom3.AddChild('Junctions');
    if (poml <> nil) then
    for j:=0 to poml.Count-1 do
      SacuvajJunction(pom4, TVeza(poml.items[j]));

  end;
end;

procedure TCSMPRadnaPovrsina.UcitajJunction(Koren: IXMLNode;var Veza: TVeza;drz:TDrzac);
var
  pomb1, pomb2: TCSMPBlok;
  pomvv: TVeza;
  pomd: IXMLNode;
  i: integer;
begin
  pomb1 := NadjiBlok(StrToInt(Koren.ChildNodes.Nodes['PocBlok'].Text));
  pomb2 := NadjiBlok(StrToInt(Koren.ChildNodes.Nodes['KrajBlok'].Text));

  pomvv := TVeza.Create(Drzaci, Self, drz.GetCentarXY, pomb2.VratiUlaznuTacku(pomvv));

  pomvv.OnChange := OnChange;

  pomvv.OnBrisanjeU := pomb2.BrisiVezuU;

  pomvv.PocBlok := pomb1;
  pomvv.KrajBlok := pomb2;
  pomvv.IsJunction := True;
  
  pomb1.DodajIVezu(pomvv);
  pomb2.DodajUVezu(pomvv, StrToInt(Koren.ChildNodes.Nodes['GdeKrajBlok'].Text));
  pomb2.OdradiMove;

  pomvv.DrzacKreiran := Drzackreiran;
  pomvv.OnSelektVeza := SelektujVezu;
  pomvv.OnDeselectVeza := DeselektujVezu;
  pomvv.OnSelektDrzac := SelektujDrzac;
  pomvv.OnDeselectDrzac := DeselektujDrzac;
  pomvv.OnSelectJunction := SelektujJunction;
  pomvv.OnDeSelectJunction := DeSelektujJunction;
  pomvv.OnBrisiJunction := BrisiDrzac;
  pomvv.OnDrzacFree := BrisiDrzac;
  pomvv.Stanje := stNone;

  pomd := Koren.ChildNodes.Nodes['Drzaci'];
  for i:=0 to pomd.ChildNodes.Count-1 do
    UcitajDrzac(pomd.ChildNodes.Nodes[i], pomvv);

  veza := pomvv;
end;

procedure TCSMPRadnaPovrsina.UcitajVezu(Koren: IXMLNode;var Veza: TVeza);
var
  pomb1, pomb2: TCSMPBlok;
  pomvv: TVeza;
  pomd: IXMLNode;
  i: integer;
begin
  pomb1 := NadjiBlok(StrToInt(Koren.ChildNodes.Nodes['PocBlok'].Text));
  pomb2 := NadjiBlok(StrToInt(Koren.ChildNodes.Nodes['KrajBlok'].Text));

  pomvv := TVeza.Create(Drzaci, Self, pomb1.IzlaznaTacka, pomb2.VratiUlaznuTacku(pomvv));
  pomvv.OnChange := OnChange;

  pomvv.OnBrisanjeI := pomb1.BrisiVezuI;
  pomvv.OnBrisanjeU := pomb2.BrisiVezuU;

  pomvv.PocBlok := pomb1;
  pomvv.KrajBlok := pomb2;

  pomb1.DodajIVezu(pomvv);
  pomb2.DodajUVezu(pomvv, StrToInt(Koren.ChildNodes.Nodes['GdeKrajBlok'].Text));
  pomb2.OdradiMove;
  
  pomvv.DrzacKreiran := DrzacKreiran;
  pomvv.OnSelektVeza := SelektujVezu;
  pomvv.OnDeselectVeza := DeselektujVezu;
  pomvv.OnSelektDrzac := SelektujDrzac;
  pomvv.OnDeselectDrzac := DeselektujDrzac;
  pomvv.OnSelectJunction := SelektujJunction;
  pomvv.OnDeSelectJunction := DeSelektujJunction;
  pomvv.OnBrisiJunction := BrisiDrzac;
  pomvv.OnDrzacFree := BrisiDrzac;
  pomvv.OnMouseClickEx := VezaDesniKlik;
  pomvv.Stanje := stNone;

  pomd := Koren.ChildNodes.Nodes['Drzaci'];
  for i:=0 to pomd.ChildNodes.Count-1 do
    UcitajDrzac(pomd.ChildNodes.Nodes[i],pomvv);

  veza:=pomvv;
end;

function TCSMPRadnaPovrsina.NadjiBlok(lb: integer): TCSMPBlok;
var
  i: integer;
begin
  for i:=0 to ComponentCount-1 do
    if (Components[i] is TCSMPBlok) then
      if (TCSMPBlok(Components[i]).LokalniBroj = lb) then
      begin
        Result := TCSMPBlok(Components[i]);
        Exit;
      end;

  Result := nil;
end;

procedure TCSMPRadnaPovrsina.UcitajDrzac(Koren: IXMLNode; var Veza: TVeza);
var
  P: TPoint;
  pom: IXMLNode;
  pomv: TVeza;
  i: integer;
  
begin
  P.X := StrToInt(Koren.ChildNodes.Nodes['Left'].Text) + 6;
  P.Y := StrToInt(Koren.ChildNodes.Nodes['Top'].Text) + 6;
  Veza.KreirajDrzac(p);
  pom := Koren.ChildNodes.Nodes['Junctions'];
  for i:=0 to pom.ChildNodes.Count - 1 do
  begin
    Self.UcitajJunction(pom.ChildNodes.Nodes[i], pomv, TDrzac(veza.LDrzaca.Last));
    pomv.IsJunction := True;
    pomv.SetColor(clBlack);
    pomv.Parent := Veza;
    TDrzac(veza.LDrzaca.Last).AddJunction(TObject(pomv));
    TDrzac(veza.LDrzaca.Last).OnDeleteJunction := Veza.BrisiJunction;
    Veze.Add(pomv);
  end;
end;

procedure TCSMPRadnaPovrsina.SetOnBrisiBlok(const Value: TNotifyEvent);
begin
  FOnBrisiBlok := Value;
end;

end.
