unit CSMPSplit;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls,
  Dialogs, ExtCtrls;

type
  TSide = ( sdLeft, sdTop, sdRight, sdBottom );
  TSides = set of TSide;

  TCSMPSplit = class (TSplitter)
  private
    FVelicina: integer;
    FPrvo: boolean; // nebitno sta radi
    FDole: boolean;
    FClick: boolean;
    FAktivniPanel: TCustomControl;
    FPretVel: integer;
    FBojaTastera: TColor;
    FHotSpotRect: TRect;
    Obnovljeno: boolean;

    procedure SetAktivniPanel(const Value: TCustomControl);
    procedure SetBojaTastera(const Value: TColor);

  protected
    procedure WMEraseBkgnd( var Msg: TMessage ); message wm_EraseBKGND;
    procedure CMMouseLeave( var Msg: TMessage ); message cm_MouseLeave;
    
  public
    HighLight: boolean;
    constructor Create(aOwner: TComponent); override;
    procedure Paint; override;
    procedure Resize; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
  published
    property AktivniPanel: TCustomControl read FAktivniPanel write SetAktivniPanel;
    property BojaTastera: TColor read FBojaTastera write SetBojaTastera;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('CSMP', [TCSMPSplit]);
end;

{ TSplit }

procedure TCSMPSplit.WMEraseBkgnd(var Msg: TMessage);
begin
  Msg.Result := 1;
end;

procedure TCSMPSplit.CMMouseLeave(var Msg: TMessage);
begin
  HighLight := False;
  invalidate;
end;

constructor TCSMPSplit.Create(aOwner: TComponent);
begin
  inherited;
  Self.MinSize := 6;
  Width := 8;
  ResizeStyle := rsPattern;
  Canvas.Brush.Color := clWhite;
  Canvas.Pen.Color := Color;
  FPrvo := True;
end;

procedure TCSMPSplit.MouseDown(Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
begin
  if PtInRect(FHotSpotRect, Point(X, Y)) then
    FClick := True;
  if (AktivniPanel <> nil) and (AktivniPanel.Visible) then
  begin
    FDole := True;
    inherited MouseDown(Button, Shift, X, Y);
  end;

end;

procedure TCSMPSplit.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
  if ((AktivniPanel <> nil) and FDole and AktivniPanel.Visible) then
  begin
    inherited MouseMove(Shift, X, Y);
    if Align in [alLeft, alRight] then
      FPretVel := AktivniPanel.Width
    else
      FPretVel := AktivniPanel.Height;
  end;

  if PtInRect(FHotSpotRect, Point(X, Y)) then
  begin
    if not Obnovljeno then
    begin
      Cursor := crHandPoint;
      HighLight := True;
      invalidate;
    end;
    Obnovljeno := True;
  end
  else
  begin
    if Obnovljeno then
    begin
      if Align in [alLeft, alRight] then
        Cursor := crHSplit
      else
        Cursor := crVSplit;
      HighLight := False;
      invalidate;
    end;
    Obnovljeno := False;
  end;
  FClick := False;
end;

procedure TCSMPSplit.MouseUp(Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
begin
  inherited;
  if (FClick and (AktivniPanel <> nil)) then
  begin
    if (not AktivniPanel.Visible and (Align = alRight)) then
      Self.Visible := False;
    AktivniPanel.Visible := not AktivniPanel.Visible;
    Visible := True;
  end;

  FClick := False;
  FDole := False;
end;

procedure TCSMPSplit.Paint;
var
  R, Rec: TRect;
  Mid, i, pom: Integer;

  function DrawSides( Canvas: TCanvas; Bounds: TRect; ULColor, LRColor: TColor;
                      Sides: TSides ): TRect;
  begin
    Canvas.Pen.Color := ULColor;
    if sdLeft in Sides then
    begin
      Canvas.MoveTo( Bounds.Left, Bounds.Top );
      Canvas.LineTo( Bounds.Left, Bounds.Bottom );
    end;

    if sdTop in Sides then
    begin
      Canvas.MoveTo( Bounds.Left, Bounds.Top );
      Canvas.LineTo( Bounds.Right, Bounds.Top );
    end;

    Canvas.Pen.Color := LRColor;
    if sdRight in Sides then
    begin
      Canvas.MoveTo( Bounds.Right - 1, Bounds.Top );
      Canvas.LineTo( Bounds.Right - 1, Bounds.Bottom );
    end;

    if sdBottom in Sides then
    begin
      Canvas.MoveTo( Bounds.Left, Bounds.Bottom - 1 );
      Canvas.LineTo( Bounds.Right, Bounds.Bottom - 1 );
    end;

    if sdLeft in Sides then
      Inc( Bounds.Left );
    if sdTop in Sides then
     Inc( Bounds.Top );
    if sdRight in Sides then
      Dec( Bounds.Right );
    if sdBottom in Sides then
      Dec( Bounds.Bottom );

    Result := Bounds;
  end;

begin
  inherited;
  if FPrvo then
  begin
    Resize;
    FPrvo := False;
  end;

  Rec := FHotSpotRect;
  Canvas.Brush.Color := Color;
  Canvas.Pen.Color := clBtnShadow;
  Canvas.FillRect(Rec);

  with Canvas, Rec do
  begin
    R := DrawSides(Canvas, Rec, clBtnShadow, clBtnShadow, [sdLeft, sdRight, sdTop, sdBottom]);
    if Highlight then
      Brush.Color := clSilver
    else
      Brush.Color := FBojaTastera;

    FillRect(R);
    DrawSides(Canvas, R, clBtnHighlight, clBtnShadow, [sdLeft, sdTop]);

    Pen.Color := clWhite;
    Brush.Color := clWhite;
    if Align in [alTop, alBottom] then
    begin
      Mid := Top + (Bottom - Top) div 2;
      if (Align = alTop) then
      begin
        { Crtaj /\ }
        Polygon( [ Point( Left + 6, Mid + 1 ),     // leva strelica
                   Point( Left + 8, Mid - 1 ),
                   Point( Left + 10, Mid + 1 ) ] );
        Polygon( [ Point( Right - 6, Mid + 1 ),    // desna strelica
                   Point( Right - 8, Mid - 1 ),
                   Point( Right - 10, Mid + 1 ) ] );
      end
      else
      begin
         { Crtaj \/ }
        Polygon( [ Point( Left + 6, Mid - 1 ),     // leva strelica
                   Point( Left + 8, Mid + 1 ),
                   Point( Left + 10, Mid - 1 ) ] );
        Polygon( [ Point( Right - 6, Mid - 1 ),    // desna strelica
                   Point( Right - 8, Mid + 1 ),
                   Point( Right - 10, Mid - 1 ) ] );
      end;

      { crtaj tackice }
      Pom := (Right - Left - 32) div 3;
      for i := 0 to Pom do
      begin
        Pixels[ Left + 15 + i * 3, Mid ] := clHighlightText;
        Pixels[ Left + 16 + i * 3, Mid + 1 ] := clHighlight;
      end;
    end
    else
    begin
      Mid := Left + ( Right - Left ) div 2;
      if ( Align = alLeft ) then
      begin
        { Crtaj < }
        Polygon( [ Point( Mid + 1, Top + 6 ),      // gornja strelica
                   Point( Mid - 1, Top + 8 ),
                   Point( Mid + 1, Top + 10 ) ] );
        Polygon( [ Point( Mid + 1, Bottom - 6 ),   // donja strelica
                   Point( Mid - 1, Bottom - 8 ),
                   Point( Mid + 1, Bottom - 10 ) ] );
      end
      else
      begin
        { Crtaj > }
        Polygon( [ Point( Mid - 1, Top + 6 ),      // gornja strelica
                   Point( Mid + 1, Top + 8 ),
                   Point( Mid - 1, Top + 10 ) ] );
        Polygon( [ Point( Mid - 1, Bottom - 6 ),   // donja strelica
                   Point( Mid + 1, Bottom - 8 ),
                   Point( Mid - 1, Bottom - 10 ) ] );
      end;

      { crtaj tackice }
      Pom := (Bottom - Top - 32) div 3;
      for i := 0 to Pom do
      begin
        Pixels[ Mid, Top + 15 + i*3 ] := clHighlightText;
        Pixels[ Mid + 1, Top + 16 + i*3 ] := clHighlight;
      end;
    end;
  end;

end;

procedure TCSMPSplit.Resize;
begin
  inherited;
  case Align of
    alLeft, alRight:
      begin
        FVelicina := Round(Height * 0.333);
        FHotSpotRect := Rect(1, FVelicina, Width - 1, FVelicina * 2);
      end;
    alTop, alBottom:
      begin
        FVelicina := Round(Width * 0.333);
        FHotSpotRect := Rect(FVelicina, 1, FVelicina * 2, Height - 1);
      end;
  end;
end;

procedure TCSMPSplit.SetAktivniPanel(const Value: TCustomControl);
begin
  FAktivniPanel := Value;
end;

procedure TCSMPSplit.SetBojaTastera(const Value: TColor);
begin
  FBojaTastera := Value;
  invalidate;
end;

end.
