unit Glavni;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, ComCtrls, ToolWin, ExtCtrls, Buttons, Menus, ActnMan,
  ActnCtrls, ActnMenus, StdActns, ActnList, XPStyleActnCtrls, StdCtrls,
  Grids, TeEngine, Series, TeeProcs, Chart, ShellApi, StdStyleActnCtrls,
  ActnColorMaps,
  CSMPGrupe, CSMPInspektor, CSMPRadnaPovrsina, CSMPSplit, unVeza,
  CSMPBlok, uUnosParam, uIzborUlaza, Obrada, Splash, uUnosOpisa;

const
  HH_DISPLAY_TOPIC = $0000;
  HH_DISPLAY_TOC = $0001;
  HH_CLOSE_ALL = $0012;
  HelpFileName = 'Help.chm';

type

  DinArray = array of integer;
  DynamicMatrix = array of array of real;

  TMainForm = class(TForm)
    HeaderPanel: TPanel;
    HelpMenuBar: TActionMainMenuBar;
    ActionManager1: TActionManager;
    FileOpen1: TFileOpen;
    FileExit1: TFileExit;
    ImageList1: TImageList;
    ImageList2: TImageList;
    ImageList3: TImageList;
    ImageList4: TImageList;
    ImageList5: TImageList;
    PageControl1: TPageControl;
    ModelTab: TTabSheet;
    CSMPInspektor1: TCSMPInspektor;
    CSMPSplit1: TCSMPSplit;
    CSMPSplit2: TCSMPSplit;
    Panel1: TPanel;
    ScrollBox1: TScrollBox;
    CSMPRadnaPovrsina1: TCSMPRadnaPovrsina;
    TabelaTab: TTabSheet;
    Tabela: TStringGrid;
    GrafikTab: TTabSheet;
    Chart1: TChart;
    Series1: TLineSeries;
    Panel3: TPanel;
    FileSaveAs1: TFileSaveAs;
    StatusBar1: TStatusBar;
    MainToolBar: TToolBar;
    TBObrisi: TToolButton;
    ToolButton10: TToolButton;
    TBRotirajD: TToolButton;
    TBRotirajL: TToolButton;
    ToolButton14: TToolButton;
    TBKreirajVezu: TToolButton;
    TBKreirajJun: TToolButton;
    TBKreirajDrzac: TToolButton;
    ToolButton18: TToolButton;
    TBSimulacija: TToolButton;
    MenuPanel: TPanel;
    MainMenu: TActionMainMenuBar;
    DoHelp: TAction;
    NovDoc: TAction;
    GoFullscreen: TAction;
    CSMPGroupBar1: TCSMPGroupBar;
    ToolButton1: TToolButton;
    TBFullscreen: TToolButton;
    Panel5: TPanel;
    BackOnModel: TSpeedButton;
    GoToChart: TSpeedButton;
    Panel6: TPanel;
    Label1: TLabel;
    ComboBox1: TComboBox;
    RotiranjeCW: TAction;
    RotiranjeCCW: TAction;
    NovaVeza: TAction;
    JunctionVeza: TAction;
    NovDrzac: TAction;
    IzvSimulaciju: TAction;
    Panel7: TPanel;
    BackOnTable: TSpeedButton;
    ChartView: TSpeedButton;
    FileSave: TAction;
    Action1: TAction;
    EditObrisi: TAction;
    Label2: TLabel;
    HelpPanel: TPanel;

    procedure FormCreate(Sender: TObject);
    procedure TBObrisiClick(Sender: TObject);
    procedure TBRotirajDClick(Sender: TObject);
    procedure TBRotirajLClick(Sender: TObject);
    procedure TBKreirajVezuClick(Sender: TObject);
    procedure TBKreirajDrzacClick(Sender: TObject);
    procedure GoFullscreenExecute(Sender: TObject);
    procedure PrevediModelClick(Sender: TObject);
    procedure TBKreirajJunClick(Sender: TObject);
    procedure BackOnTableClick(Sender: TObject);
    procedure TabelaDblClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure DoHelpExecute(Sender: TObject);
    procedure FileSaveAs1Accept(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FileOpen1Accept(Sender: TObject);
    procedure NovDocExecute(Sender: TObject);
    procedure TabelaKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure ChartViewClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure BackOnModelClick(Sender: TObject);
    procedure GoToChartClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ComboBox1Change(Sender: TObject);
    procedure FileSaveExecute(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure TabelaDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure FormShow(Sender: TObject);

  private
    FPrevWidth, FPrevHeight, FPrevTop, FPrevLeft: integer;
    FKliknutRed: integer;
    FImeFajla: string;
    procedure SetKliknutRed(const Value: integer);
    procedure AOnHint(sender: TObject);
    procedure WMGetMinMaxInfo(var Msg: TWMGetMinMaxInfo); message WM_GETMINMAXINFO;
    procedure SetImeFajla(const Value: string);

  public
    PrevedenNiz: TList;
    SortiranNiz: DinArray;
    BrSortiranih: integer;
    BrojKonstanti: integer;
    Matrix: Obrada.MatrixReal;
    Menjano: boolean;
    CBList: TList; // lista CheckBox-ova na izlaznoj tabeli simulacije

    property KliknutRed: integer read FKliknutRed write SetKliknutRed;
    procedure KliknutBlok(Sender: TObject);
    procedure UnosParametara(Sender: TObject);
    procedure IzaberiUlaz(Sender: TObject);
    procedure CrtajGrafik(Red: integer);
    procedure PromenaStanja(Sender: TObject);
    procedure NestoJeMenjano(Sender: TObject);
    procedure ObrisanBlok(Sender: TObject);
    property ImeFajla: string read FImeFajla write SetImeFajla;
  end;

var
  MainForm: TMainForm;


implementation

{$R *.dfm}

function HtmlHelp(hwndCaller: HWND;
  pszFile: PChar; uCommand: UINT;
  dwData: DWORD): HWND; stdcall; external 'HHCTRL.OCX' name 'HtmlHelpA';

procedure TMainForm.WMGetMinMaxInfo(var Msg: TWMGetMinMaxInfo);
begin
  Msg.MinMaxInfo^.ptMinTrackSize := Point(630, 450);
  inherited;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  i: integer;
begin
  ImeFajla := '.csmp';
  Application.OnHint := AOnHint;
  ImageList1.BkColor := clWhite;
  CSMPGroupBar1.LoadFromXML('Manifest.xml');
  CSMPRadnaPovrsina1.OnSelectBlok := KliknutBlok;
  CSMPRadnaPovrsina1.OnDropBlok := UnosParametara;
  CSMPRadnaPovrsina1.OnPoveziVezu := IzaberiUlaz;
  CSMPRadnaPovrsina1.OnChange := NestoJeMenjano;
  CSMPRadnaPovrsina1.OnStanjeChange := PromenaStanja;
  CSMPRadnaPovrsina1.OnBrisiBlok := ObrisanBlok;
  PrevedenNiz := TList.Create;
  CBList := TList.Create;
  Menjano := False;
  for i := 1 to CSMPGroupBar1.Grupe.Count - 1 do
    TCSMPGrupa(CSMPGroupBar1.Grupe.Items[i]).Visible := False;
    
  // ako se program pokrenuo klikom na fajl *.csmp onda ga treba ucitati
  if (Trim(ParamStr(1)) <> '') and (FileExists(Trim(ParamStr(1)))) then
  begin
    CSMPRadnaPovrsina1.LoadFromFile(Trim(ParamStr(1)));
    ImeFajla := ExtractFileName(Trim(ParamStr(1)));
    CSMPInspektor1.OsveziListu(CSMPRadnaPovrsina1);
  end;
end;

procedure TMainForm.TBObrisiClick(Sender: TObject);
begin
  if (PageControl1.ActivePageIndex = 0) then
    CSMPRadnaPovrsina1.ObrisiSelektovano;
end;

procedure TMainForm.TBRotirajDClick(Sender: TObject);
begin
  if (PageControl1.ActivePageIndex = 0) then
    if (CSMPRadnaPovrsina1.SelektovanBlok <> nil) then
    begin
      CSMPRadnaPovrsina1.SelektovanBlok.RotirajC;
      Menjano := True;
    end;
end;

procedure TMainForm.TBRotirajLClick(Sender: TObject);
begin
  if (PageControl1.ActivePageIndex = 0) then
    if (CSMPRadnaPovrsina1.SelektovanBlok <> nil) then
    begin
      CSMPRadnaPovrsina1.SelektovanBlok.RotirajCC;
      Menjano := True;
    end;
end;

procedure TMainForm.TBKreirajVezuClick(Sender: TObject);
begin
  if (PageControl1.ActivePageIndex = 0) then
  begin
    if TBKreirajVezu.Down then
      TBKreirajVezu.Down := False
    else
    begin
      CSMPRadnaPovrsina1.Stanje := rpsDodajVezuEx;
      StatusBar1.SimpleText := 'Dodavanje veze';
    end;
  end;
end;

procedure TMainForm.TBKreirajDrzacClick(Sender: TObject);
begin
  if (PageControl1.ActivePageIndex = 0) then
    CSMPRadnaPovrsina1.Stanje := rpsDodajDrzac;
end;

procedure TMainForm.GoFullscreenExecute(Sender: TObject);
begin
  if (BorderStyle <> bsNone) then
  begin
    FPrevWidth := Width;
    FPrevHeight := Height;
    FPrevTop := Top;
    FPrevLeft := Left;
    BorderStyle := bsNone;
    WindowState := wsMaximized;
  end
  else
  begin
    Width := FPrevWidth;
    Height := FPrevHeight;
    Top := FPrevTop;
    Left := FPrevLeft;
    BorderStyle := bsSizeable;
    WindowState := wsNormal;
  end;
end;

procedure TMainForm.PrevediModelClick(Sender: TObject);
var
  i, j, Pom, Count: integer;
  Check: TCheckBox;

begin
  if (PageControl1.ActivePageIndex <> 0) then Exit;
  PrevedenNiz.Clear;
  while CBList.Count>0 do
  begin
    check := TCheckBox(CBList.Items[0]);
    CBList.Delete(0);
    check.Free;
  end;
  // prevedi model u niz pogodan za manipulaciju
  for i := 0 to CSMPRadnaPovrsina1.ComponentCount - 1 do
    if (CSMPRadnaPovrsina1.Components[i] is TCSMPBlok) then
      PrevedenNiz.Add(TCSMPBlok(CSMPRadnaPovrsina1.Components[i]));
  // simulacija i prikaz rezultata
  try
    begin
      Simulacija.Pocetak(PrevedenNiz, Matrix);
      if (Simulacija.SimulacijaOdradjena = True) then
      begin
//        Tabela.RowCount:=2;
//        Tabela.ColCount:=2;
        PageControl1.ActivePage := TabelaTab;
        MainToolBar.Visible := False;

        Tabela.RowCount := PrevedenNiz.Count + 1;
        Pom := Round(Simulacija.DuzinaSimulacije / Simulacija.IntervalStampanja) + 1;
        Tabela.ColCount := Pom + 1;

      // ispisi intervale u naslovima kolona
        for i := 0 to Pom + 1 do
          Tabela.Cells[i + 1, 0] := FloatToStr(i * Simulacija.IntervalStampanja);

        CBList.Clear;
        Count := -1;
        for i := 0 to PrevedenNiz.Count - 1 do
        begin
          if TCSMPBlok(PrevedenNiz.Items[i]).Sifra in [12, 25] then
          begin
            Tabela.RowCount := Tabela.RowCount - 1;
            Continue;
          end;

          Inc(Count);
          Check := TCheckBox.Create(nil);
          Check.Caption := IntToStr(TCSMPBlok(PrevedenNiz.Items[i]).LokalniBroj) +
          '. ' + TCSMPBlok(PrevedenNiz.Items[i]).Naziv;
          Check.Hint := Check.Caption;
          Check.Parent := TabelaTab;
          Check.Color := clBtnShadow;
          Check.Font.Color := clMaroon;
          Check.Font.Style := [fsBold];
          CBList.Add(Check);

          for j := 1 to Pom + 2 do
            Tabela.Cells[j, Count + 1] := FloatToStr(Matrix[j - 1, i]);

          FKliknutRed := 0;
        end;
      end;
    end;
  except
    on e: Exception do
    begin
      MessageDlg('Doslo je do neocekivane greske tokom simulacije!' + #13 +
        'Greska: ' + e.Message+ #13 +
        'Probajte sa smanjenom duzine simulacije ili drugim parametrima za blokove.',
        mtError, [mbOK], 0);
      BackOnModelClick(Sender);
    end;
  end;
  PrevedenNiz.Clear;

end;

procedure TMainForm.KliknutBlok(Sender: TObject);
begin
  if CSMPInspektor1.Visible then
    CSMPInspektor1.Popuni(CSMPRadnaPovrsina1.SelektovanBlok);
end;

procedure TMainForm.UnosParametara(Sender: TObject);
var
  FS: TFormatSettings;

begin
  FS.DecimalSeparator := '.';
  if (TCSMPRadnaPovrsina(Sender).SelektovanBlok.BrojPar <> 0) then
  begin
    UnosPar.Label1.Enabled := True;
    UnosPar.Label1.Caption := TCSMPRadnaPovrsina(Sender).SelektovanBlok.Nazivi[0] + ':';
    UnosPar.Edit1.Enabled := True;
    UnosPar.Label2.Enabled := False;
    UnosPar.Edit2.Enabled := False;
    UnosPar.Label3.Enabled := False;
    UnosPar.Edit3.Enabled := False;

    with TCSMPRadnaPovrsina(sender) do
    begin
      case SelektovanBlok.BrojPar of
        2: begin
            UnosPar.Label2.Enabled := True;
            UnosPar.Label2.Caption := SelektovanBlok.Nazivi[1] + ':';
            UnosPar.Edit2.Enabled := True;
          end;
        3: begin
            UnosPar.Label2.Enabled := True;
            UnosPar.Label2.Caption := SelektovanBlok.Nazivi[1] + ':';
            UnosPar.Edit2.Enabled := True;
            UnosPar.Label3.Enabled := True;
            UnosPar.Label3.Caption := SelektovanBlok.Nazivi[2] + ':';
            UnosPar.Edit3.Enabled := True;
          end;
      end;

      UnosPar.ShowModal;

      if not UnosPar.Ok then
        ObrisiSelektovano
      else
      begin
        SelektovanBlok.ParI := StrToFloat(UnosPar.Edit1.Text, FS);
        SelektovanBlok.ParII := StrToFloat(UnosPar.Edit2.Text, FS);
        SelektovanBlok.ParIII := StrToFloat(UnosPar.Edit3.Text, FS);
        KliknutBlok(Sender);
      end;
    end;
  end
  else
    KliknutBlok(Sender);

  CSMPInspektor1.OsveziListu(CSMPRadnaPovrsina1);
end;

procedure TMainForm.IzaberiUlaz(Sender: TObject);
var
  pom: TCSMPBlok;
  pomv: TVeza;

begin
  if TCSMPRadnaPovrsina(Sender).Stanje in [rpsKreirajJunctionEx, rpsDodajVezuEx] then
  begin
    pom := TCSMPBlok(TCSMPRadnaPovrsina(sender).TempDinV.KrajBlok);
    pomv := TCSMPRadnaPovrsina(sender).TempDinV;

    if (pom.MaxUlaznihVeza > 0) then
    begin
      with TCSMPRadnaPovrsina(sender) do
      begin
        IzborUlaza.RadioButton1.Enabled := (pom.UlazneVeze.Items[0] = nil);
        IzborUlaza.RadioButton2.Enabled := ((pom.UlazneVeze.Items[1] = nil)
          and (pom.MaxUlaznihVeza > 1));
        IzborUlaza.RadioButton3.Enabled := ((pom.UlazneVeze.Items[2] = nil)
          and (pom.MaxUlaznihVeza > 2));

        if (IzborUlaza.RadioButton3.Enabled or IzborUlaza.RadioButton2.Enabled
          or IzborUlaza.RadioButton1.Enabled) then
        begin
          IzborUlaza.ShowModal;
          if not IzborUlaza.Ok then
            ObrisiVezu(pomv)
          else
          begin
            if IzborUlaza.RadioButton1.Checked then
              pom.DodajUVezu(pomv, 0)
            else
              if IzborUlaza.RadioButton2.Checked then
                pom.DodajUVezu(pomv, 1)
              else pom.DodajUVezu(pomv, 2);
            Pom.OdradiMove;
          end;
          SelektovanBlok := pom;
          SelektovanBlok.Aktivno := True;
          KliknutBlok(Sender);
          Menjano := True;
        end
        else
        begin
          if CSMPRadnaPovrsina1.Stanje = rpsKreirajjunctionEx then
            CSMPRadnaPovrsina1.TempDinV.Parent.ObrisiDrzacM(CSMPRadnaPovrsina1.TempDinV.Parent.GetLastDrzac);
          ShowMessage('Maksinalni broj ulaznih veza za blok <' + pom.naziv + '> je ' + IntToStr(pom.MaxUlaznihVeza) + '!');
          CSMPRadnaPovrsina1.ObrisiVezu(pomv);
        end;
      end; // with
    end // if pom.maxul..
    else
    begin
      if (CSMPRadnaPovrsina1.Stanje = rpsKreirajjunctionEx) then
        CSMPRadnaPovrsina1.TempDinV.Parent.ObrisiDrzacM(CSMPRadnaPovrsina1.TempDinV.Parent.GetLastDrzac);
      ShowMessage('Blok: <' + pom.naziv + '> ne moze da ima ulaznu vezu!');
      CSMPRadnapovrsina1.ObrisiVezu(pomv);
    end;
  end;
end;

procedure TMainForm.TBKreirajJunClick(Sender: TObject);
begin
  if (PageControl1.ActivePageIndex = 0) then
    CSMPRadnaPovrsina1.Stanje := rpsKreirajJunctionEx;
end;

procedure TMainForm.SetKliknutRed(const Value: integer);
begin
  FKliknutRed := Value;
  CrtajGrafik(Value);
end;

procedure TMainForm.CrtajGrafik(Red: integer);
var
  i, j: integer;
  s: TLineSeries;
  Pom: integer;
  Found: boolean;

begin
  Chart1.RemoveAllSeries;
  series1.Clear;
  Series1.ParentChart := nil;
  Found := False;
  for i := 0 to CBList.Count - 1 do
  begin
    if TCheckBox(CBList.Items[i]).Checked then
    begin
      s := TLineSeries.Create(chart1);
      s.clear;
      S.ParentChart := nil;
      Pom := Round(Simulacija.DuzinaSimulacije / Simulacija.IntervalStampanja);
      for j := 0 to Pom - 1 do
        S.AddXY(j * Simulacija.IntervalStampanja, StrToFloat(Tabela.Cells[j + 1, i + 1]));

      S.Title := TCheckBox(CBList.Items[i]).Caption;
      Chart1.AddSeries(S);
      Found := True;
    end;
  end;

  if Found then
  begin
    Chart1.UndoZoom;
    Chart1.BottomAxis.Automatic := True;
    PageControl1.ActivePage := GrafikTab;
  end
  else
    ShowMessage('Niste oznacili zeljene izlaze!');
end;

procedure TMainForm.BackOnTableClick(Sender: TObject);
begin
  PageControl1.ActivePage := TabelaTab;
end;

procedure TMainForm.TabelaDblClick(Sender: TObject);
begin
  KliknutRed := Tabela.Row;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  PrevedenNiz.Free;
  CBList.Free;
end;

procedure TMainForm.DoHelpExecute(Sender: TObject);
begin
  HtmlHelp(handle, PChar(ExtractFilePath(Application.EXEName) + HelpFileName + '::/index.htm'), HH_DISPLAY_TOPIC, 0);
end;

procedure TMainForm.FileSaveAs1Accept(Sender: TObject);
begin
  ImeFajla := ExtractFileName(FileSaveAs1.Dialog.FileName);
  CSMPRadnaPovrsina1.SaveToFile(ImeFajla + '.csmp');
  Menjano := False;
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (key = VK_F1) then
  begin
    if (CSMPRadnaPovrsina1.SelektovanBlok <> nil) then
      HtmlHelp(handle, PChar(ExtractFilePath(Application.EXEName) + HelpFileName + '::/' + IntToStr(CSMPRadnaPovrsina1.SelektovanBlok.Sifra) + '.htm'), HH_DISPLAY_TOc, 0)
    else
      HtmlHelp(handle, PChar(ExtractFilePath(Application.EXEName) + HelpFileName + '::/index.htm'), HH_DISPLAY_TOPIC, 0);
  end;
end;

procedure TMainForm.AOnHint(sender: TObject);
begin
  StatusBar1.SimpleText := GetLongHint(Application.Hint);
end;

procedure TMainForm.FileOpen1Accept(Sender: TObject);
begin
  BackOnModelClick(Sender);
  NovDocExecute(Sender);
  CSMPRadnaPovrsina1.LoadFromFile(FileOpen1.Dialog.FileName);
  ImeFajla := ExtractFileName(FileOpen1.Dialog.FileName);
  CSMPInspektor1.OsveziListu(CSMPRadnaPovrsina1);
  Menjano := False;
end;

procedure TMainForm.NovDocExecute(Sender: TObject);
var
  pom: integer;
begin
  if Menjano then
    pom := MessageDlg('Da li zelite da sacuvate promene?', mtWarning, [mbYes, mbNo, mbCancel], 0)
  else
    Pom := mrNo;

  BackOnModelClick(Sender);

  case pom of
    mrYes:
      begin
        if (ImeFajla = '') then
          if FileSaveAs1.Dialog.Execute then
            ImeFajla := ExtractFileName(FileSaveAs1.Dialog.FileName)
          else
            Exit
        else
          ImeFajla := ImeFajla + '.csmp';
        CSMPRadnapovrsina1.SaveToFile(FileSaveAs1.Dialog.FileName);
        CSMPRadnaPovrsina1.ObrisiSve;
        CSMPInspektor1.OsveziListu(CSMPRadnaPovrsina1);
        Menjano := False;
      end;
    mrNo:
      begin
        CSMPRadnaPovrsina1.ObrisiSve;
        CSMPInspektor1.OsveziListu(CSMPRadnaPovrsina1);
        Menjano := False;
        ImeFajla := '.csmp';
      end;
  end;

end;

procedure TMainForm.TabelaKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (key = VK_RETURN) then
    Tabela.OnDblClick(sender);
end;

procedure TMainForm.ChartViewClick(Sender: TObject);
begin
  Chart1.View3D := not Chart1.View3D;
  if Chart1.View3D then
    ChartView.Caption := '2D View'
  else
    ChartView.Caption := '3D View'
end;

procedure TMainForm.FormResize(Sender: TObject);
var
  pom: integer;
begin
  Pom := (Self.Width - MainToolBar.Width) shr 1 - 15;
  if (Pom > 97) then
    MenuPanel.Width := Pom
  else
    MenuPanel.Width := 97;
end;

procedure TMainForm.BackOnModelClick(Sender: TObject);
begin
  PageControl1.ActivePage := ModelTab;
  MainToolBar.Visible := True;
end;

procedure TMainForm.GoToChartClick(Sender: TObject);
begin
  Tabela.OnDblClick(sender);
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Menjano then
  begin
    case MessageDlg('Da li zelite da sacuvate promene?', mtWarning,
      [mbYes, mbNo, mbCancel], 0)
    of
      mrYes:
        begin
          FileSaveExecute(Sender);
          CSMPRadnaPovrsina1.ObrisiSve;
        end;
      mrCancel: Action := caNone;
    end;
  end;
end;

procedure TMainForm.ComboBox1Change(Sender: TObject);
var
  i: integer;
begin
  if (ComboBox1.ItemIndex = 0) then
  begin
    TCSMPGrupa(CSMPGroupBar1.Grupe.Items[0]).Visible := True;
    for i := 1 to CSMPGroupBar1.Grupe.Count - 1 do
      TCSMPGrupa(CSMPGroupBar1.Grupe.Items[i]).Visible := False;

    CSMPGroupBar1.AktivnaGrupa := TCSMPGrupa(CSMPGroupBar1.Grupe.Items[0]);
  end
  else
  begin
    TCSMPGrupa(CSMPGroupBar1.Grupe.Items[0]).Visible := False;
    for i := 1 to CSMPGroupBar1.Grupe.Count - 1 do
      TCSMPGrupa(CSMPGroupBar1.Grupe.Items[i]).Visible := True;

    CSMPGroupBar1.AktivnaGrupa := TCSMPGrupa(CSMPGroupBar1.Grupe.Items[1]);
  end;
end;

procedure TMainForm.PromenaStanja(Sender: TObject);
begin
  TBKreirajVezu.Down := False;
  TBKreirajJun.Down := False;
  TBKreirajDrzac.Down := False;
  case CSMPRadnaPovrsina1.Stanje of
    rpsDodajVezuEx: TBKreirajVezu.Down := True;
    rpsDodajDrzac: TBKreirajDrzac.Down := True;
    rpsKreirajJunctionEx: TBKreirajJun.Down := True;
  end;
end;

procedure TMainForm.FileSaveExecute(Sender: TObject);
begin
  if (ImeFajla = '') then
    if FileSaveAs1.Dialog.Execute then
      ImeFajla := ExtractFileName(FileSaveAs1.Dialog.FileName);
  CSMPRadnaPovrsina1.SaveToFile(ImeFajla + '.csmp');
  Menjano := False;
end;

procedure TMainForm.SetImeFajla(const Value: string);
begin
  FImeFajla := Value;
  SetLength(FImeFajla, Length(FImeFajla) - 5);
  if (ImeFajla <> '') then
    Caption := 'CSMP - ' + FImeFajla
  else
    Caption := 'CSMP - Dok1'
end;

procedure TMainForm.NestoJeMenjano(Sender: TObject);
begin
  Menjano := True;
end;

procedure TMainForm.BitBtn1Click(Sender: TObject);
begin
  UnosOpisa.Memo1.Text := CSMPRadnaPovrsina1.OpisProblema;
  UnosOpisa.ShowModal;

  if UnosOpisa.Ok then
  begin
    CSMPRadnaPovrsina1.OpisProblema := UnosOpisa.Tekst;
    Menjano := True;
  end;
end;

procedure TMainForm.ObrisanBlok(Sender: TObject);
begin
  CSMPInspektor1.OsveziListu(CSMPRadnaPovrsina1);
end;

procedure TMainForm.TabelaDrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
begin
  inherited;
  if ((ACol = 0) and (ARow > 0) and (CBList.Count > 0)) then
  begin
    TCheckBox(CBList.Items[ARow - 1]).SetBounds(Rect.Left + 1, Rect.Top + 1 + Tabela.Top,
      Rect.Right - Rect.Left - 1, Rect.Bottom - Rect.Top - 1);
    TCheckBox(CBList.Items[ARow - 1]).BringToFront;
  end;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  Resize;
end;

end.

