unit OpcijeSim;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, Buttons, StdCtrls;

type

  TOpcije = class(TForm)
    Image1: TImage;
    Panel1: TPanel;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Group: TGroupBox;
    Label4: TLabel;
    Image2: TImage;

    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);

  private
    procedure WMNCHITTEST(var msg: TMessage);message WM_NCHITTEST;
    procedure WMERASE(var msg: TMessage);message WM_ERASEBKGND;

  public

    Ok: boolean;
    DuzInt: real;
    IntInt: real;
    IntStamp: real;
  end;

var
  Opcije: TOpcije;

implementation

{$R *.dfm}

{ TOpcije }

procedure TOpcije.WMERASE(var msg: TMessage);
begin
  msg.Result := 1;
end;

procedure TOpcije.WMNCHITTEST(var msg: TMessage);
var
  Tacka:TPoint;
begin
  inherited;
  Tacka.X := LOWORD(msg.LParam)-left;
  Tacka.Y := HIWORD(msg.LParam)-top;
  if (Msg.Result = htClient) and PtInRect(Rect(0, 0, 502, 17), Tacka) then
    msg.Result := htCaption;
end;

procedure TOpcije.SpeedButton1Click(Sender: TObject);
var
  FS: TFormatSettings;
begin
  FS.DecimalSeparator := '.';
  if (Edit1.Text <> '') and (Edit2.Text <> '') and (Edit3.Text<> '') then
  begin
    DuzInt := StrToFloatDef(Edit1.Text, MaxInt, FS);
    if (DuzInt = MaxInt) or (DuzInt <= 0) then
    begin
      MessageDlg('Duzina trajanja simulacije mora biti pozitivan realan broj!', mtError, [mbOK], 0);
      Edit2.SelectAll;
      Edit2.SetFocus;
      Exit;
    end;

    IntInt := StrToFloatDef(Edit2.Text, MaxInt, FS);
    if (IntInt = MaxInt) or (IntInt <= 0) then
    begin
      MessageDlg('Interval integracije mora biti pozitivan realan broj!', mtError, [mbOK], 0);
      Edit2.SelectAll;
      Edit2.SetFocus;
      Exit;
    end;

    if (DuzInt < IntInt) then
    begin
      MessageDlg('Duzina trajanja simulacije mora biti veca od intervala integracije!', mtError, [mbOK], 0);
      Edit2.SelectAll;
      Edit2.SetFocus;
      Exit;
    end;

    IntStamp := StrToFloatDef(Edit3.Text, MaxInt, FS);
    if (IntStamp = MaxInt) or (IntStamp <= 0) then
    begin
      MessageDlg('Interval stampanja mora biti pozitivan realan broj!', mtError, [mbOK], 0);
      Edit2.SelectAll;
      Edit2.SetFocus;
      Exit;
    end;

    if (IntStamp < IntInt) or (IntStamp >= DuzInt) then
    begin
      MessageDlg('Interval stampanja rezultata mora biti'+#13+
                 'veci ili jednak intervalu integracije i'+#13+
                 '  manji od duzine trajanja simulacije!', mtError, [mbOK], 0);
      Edit3.SetFocus;
      exit;
    end;
    Ok := True;
    Close;
  end
  else
    MessageDlg('Niste uneli sve potrebne vrednosti!', mtError, [mbOK], 0);
end;

procedure TOpcije.SpeedButton2Click(Sender: TObject);
begin
  Ok := False;
  Close;
end;

end.
