unit Skroler;

interface

uses
  Windows, SysUtils, Messages, Classes, Controls, Forms, Graphics, XMLIntf, Types,
  StdCtrls;

type

  TSkrolStavka = class(TCustomControl)
  private
    FImageIndex: integer;
    FNaziv: string;
    FLabela: TLabel;
    FMaxUlaznihVeza: integer;
    FBrojParam: integer;

    procedure SetImageIndex(const Value: integer);
    procedure SetNaziv(const Value: string);
    procedure SetLabela(const Value: TLabel);
    procedure SetMaxUlaznihVeza(const Value: integer);
    procedure SetBrojParam(const Value: integer);

  protected
    Stanje: boolean;

  public
    Node: IXMLNode;
    Nazivi: array[0..5] of string;
    constructor Create(AOwner: TComponent; uNode: IXMLNode); overload;
    procedure Paint; override;
    procedure PodesiPolozaj;
    procedure CMMouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;

  published
    property ImageIndex: integer read FImageIndex write SetImageIndex default 0;
    property Naziv: string read FNaziv write SetNaziv;
    property MaxUlaznihVeza: integer read FMaxUlaznihVeza write SetMaxUlaznihVeza;
    property BrojParam: integer read FBrojParam write SetBrojParam;
    property Height default 56;
    property Width default 56;
    property Labela: TLabel read FLabela write SetLabela;
  end;

  TSkroler = class(TScrollBox)
  private
    FSlike: TImageList;
    FbrCol: Byte; // broj kolona
    FOldBrCol: Byte; // broj kolona
    procedure SetSlike(const Value: TImageList);

  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure LoadFromXMLManifest(Stavke: IXMLNodeList);
    procedure Resize; override;

  published
    property Slike: TImageList read FSlike write SetSlike;
    property Color default clWhite;
    property BorderStyle default bsNone;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('CSMP', [TSkroler]);
end;

{ TSkroler }

constructor TSkroler.Create(AOwner: TComponent);
begin
  inherited;
  self.Color := clWhite;
  self.BorderStyle := bsNone;
  self.HorzScrollBar.Visible := false;
  self.VertScrollBar.Tracking := true;
  self.FOldBrCol := 0;
  self.FbrCol := 0;
end;

destructor TSkroler.Destroy;
begin
  inherited;
end;

procedure TSkroler.LoadFromXMLManifest(Stavke: IXMLNodeList);
var
  i: integer;
  pom: TSkrolStavka;
  poml: TLabel;
  s: integer;
begin
  s := 5;
  for i := 0 to Stavke.Count - 1 do
  begin
    pom := TSkrolStavka.Create(self, Stavke.Nodes[i]);
    pom.Parent := Self;
    pom.SetBounds(16, s, pom.Width, pom.Height);
    pom.PodesiPolozaj;
    Poml := TLabel.Create(self);
    poml.AutoSize := true;
    Poml.WordWrap := true;
    Poml.Width := pom.Width + 30;
    Poml.Parent := self;
    Poml.Caption := pom.Hint;
    poml.Top := 0;
    Poml.Alignment := taCenter;
    Poml.Left := 0;
    poml.Top := pom.Top + pom.Height + 2;
    pom.Labela := poml;
    s := s + pom.labela.Height + 12 + pom.Height;
  end;
end;

procedure TSkroler.Resize;
var
  i: integer;
begin
  inherited;

  if (Self.Width > 65) then
    FbrCol := ((Self.Width + 15) div 80)
  else
    FbrCol := 1;

  if FbrCol <> FOldBrCol then
  begin
    FoldBrCol := FBrCol;
    for i := 0 to (Self.ComponentCount - 1) do
      if Components[i] is TSkrolStavka then
      begin
        TSkrolStavka(Self.Components[i]).PodesiPolozaj;
      end;
    invalidate;
  end;
end;

procedure TSkroler.SetSlike(const Value: TImageList);
begin
  FSlike := Value;
end;

{ TSkrolStavka }

procedure TSkrolStavka.CMMouseEnter(var Message: TMessage);
begin
  inherited;
  Stanje := True;
  Invalidate;
end;

procedure TSkrolStavka.CMMouseLeave(var Message: TMessage);
begin
  inherited;
  Stanje := False;
  Invalidate;
end;

constructor TSkrolStavka.Create(AOwner: TComponent; uNode: IXMLNode);
begin
  inherited Create(AOwner);
  Node := uNode;
  Stanje := false;
  DragMode := dmAutomatic;
  Height := 56;
  Width := 56;
  Hint := UNode.ChildNodes.Nodes['naziv'].NodeValue;
  Naziv := Hint;
  ImageIndex := UNode.ChildNodes.Nodes['sifra'].NodeValue;
  MaxUlaznihVeza := UNode.ChildNodes.Nodes['maxuveza'].NodeValue;
  BrojParam := UNode.ChildNodes.Nodes['brparam'].NodeValue;
  Nazivi[0] := UNode.ChildNodes.Nodes['str1'].NodeValue;
  Nazivi[1] := UNode.ChildNodes.Nodes['str2'].NodeValue;
  Nazivi[2] := UNode.ChildNodes.Nodes['str3'].NodeValue;
  Nazivi[3] := UNode.ChildNodes.Nodes['str4'].NodeValue;
  Nazivi[4] := UNode.ChildNodes.Nodes['str5'].NodeValue;
  Nazivi[5] := UNode.ChildNodes.Nodes['str6'].NodeValue;
  Parent := TSkroler(AOwner);
  PodesiPolozaj;
end;

procedure TSkrolStavka.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
  inherited;
  Cursor := crDrag;
  invalidate;
end;

procedure TSkrolStavka.Paint;
var
  Rec: TRect;
begin
  inherited;
  if TSkroler(Owner).Slike <> nil then
  begin
    if not stanje then
    begin
      Canvas.Brush.Color := TSkroler(Parent).Color;
      Canvas.Pen.Color := TSkroler(Parent).Color;
      Canvas.Pen.Width := 1;
      rec := self.GetClientRect;
      Canvas.RoundRect(rec.Left + 4, rec.Top + 4, rec.Right, rec.Bottom, 10, 10);
      Canvas.Brush.Color := clWhite;
      Canvas.Pen.Color := clBlack;
      Canvas.RoundRect(rec.Left, rec.Top, rec.Right - 4, rec.Bottom - 4, 10, 10);
      TSkroler(Owner).Slike.Draw(Canvas, 5, 5, imageIndex);
    end
    else
    begin
      Canvas.Brush.Color := clWhite;
      Canvas.Pen.Color := clBlack;
      Canvas.Pen.Width := 1;
      rec := self.GetClientRect;
      Canvas.RoundRect(rec.Left + 4, rec.Top + 4, rec.Right, rec.Bottom, 10, 10);
      TSkroler(Owner).Slike.Draw(Canvas, 9, 9, imageIndex);
    end;
  end
  else
  begin
    Canvas.Brush.Color := clRed;
    Canvas.Rectangle(self.GetClientRect);
  end;
end;

procedure TSkrolStavka.PodesiPolozaj;
var
  pom, i, s, maxhl, maxh: integer;
  c: byte;
  poms: TSkrolStavka;
begin
  pom := TSkroler(Parent).Width div 2 - (Width div 2);
  if (pom <> Left) then
    Left := pom;

  c := 0;
  s := 5;
  maxh := 0;
  maxhl := 0;
  for i := 0 to TSkroler(Parent).ComponentCount - 1 do
  begin
    if TSkroler(Parent).Components[i] is TSkrolStavka then
    begin
      poms := TSkrolStavka(TSkroler(Parent).Components[i]);
      if c = TSkroler(Parent).FbrCol then
      begin
        c := 0; s := s + maxhl + 12 + maxh; maxh := 0; maxhl := 0;
      end;
      poms.Left := 15+(c * 80);
      poms.Top := s;
      if poms.Height > maxh then
        maxh := poms.height;
      if poms.Labela <> nil then
      begin
        if poms.Labela.Height > maxhl then
          maxhl := poms.Labela.Height;
        poms.Labela.Top := poms.Top + poms.Height + 2;
      end;
      inc(c);
    end;
  end;

  if labela <> nil then
    Labela.Left := (left + (Width div 2)) - (labela.Width div 2);

end;

procedure TSkrolStavka.SetBrojParam(const Value: integer);
begin
  FBrojParam := Value;
end;

procedure TSkrolStavka.SetImageIndex(const Value: integer);
begin
  FImageIndex := value;
end;

procedure TSkrolStavka.SetLabela(const Value: TLabel);
begin
  FLabela := Value;
end;

procedure TSkrolStavka.SetMaxUlaznihVeza(const Value: integer);
begin
  FMaxUlaznihVeza := Value;
end;

procedure TSkrolStavka.SetNaziv(const Value: string);
begin
  FNaziv := value;
end;

end.

