unit uUnosParam;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TUnosPar = class(TForm)
    Image1: TImage;
    Image2: TImage;
    CaptionLabel: TLabel;
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    GroupBox2: TGroupBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Panel2: TPanel;
    
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure Panel7Click(Sender: TObject);

  private
    procedure WMNCHITTEST(var msg:TMessage);message WM_NCHITTEST;
    procedure WMERASE(var msg:TMessage);message WM_ERASEBKGND;

  public
    Ok: boolean;

  end;

var
  UnosPar: TUnosPar;

implementation

{$R *.dfm}

procedure TUnosPar.SpeedButton1Click(Sender: TObject);
var
  FS: TFormatSettings;

begin
  FS.DecimalSeparator := '.';
  if (StrToFloatDef(Edit1.Text, MaxInt, FS) = MaxInt) then
  begin
    MessageDlg('Molim vas da unesete broj!', mtError, [mbOK], 0);
    Edit1.SelectAll;
    Edit1.SetFocus;
    Exit;
  end;

  if (StrToFloatDef(Edit2.Text, MaxInt, FS) = MaxInt) then
  begin
    MessageDlg('Molim vas da unesete broj!', mtError, [mbOK], 0);
    Edit2.SelectAll;
    Edit2.SetFocus;
    Exit;
  end;

  if (StrToFloatDef(Edit3.Text, MaxInt, FS) = MaxInt) then
  begin
    MessageDlg('Molim vas da unesete broj!', mtError, [mbOK], 0);
    Edit3.SelectAll;    
    Edit3.SetFocus;
    Exit;
  end;

  Ok := True;
  Close;
end;

procedure TUnosPar.FormShow(Sender: TObject);
begin
  Edit1.Text := '0';
  Edit2.Text := '0';
  Edit3.Text := '0';
  AdjustSize;
end;

procedure TUnosPar.SpeedButton2Click(Sender: TObject);
begin
  Ok := False;
  Close;
end;

procedure TUnosPar.Panel7Click(Sender: TObject);
begin
  MessageDlg('Kod nekih blokova redosled i vrednosti parametara su bitni !!!',
    mtInformation, [mbOk], 0);
end;

procedure TUnosPar.WMERASE(var msg: TMessage);
begin
  msg.Result := 1;
end;

procedure TUnosPar.WMNCHITTEST(var msg: TMessage);
var
  Tacka: TPoint;
begin
  inherited;
  Tacka.X := LOWORD(msg.LParam)-left;
  Tacka.Y := HIWORD(msg.LParam)-top;
  if (Msg.Result = htClient) and PtInRect(Rect(0, 0, Width, 17), Tacka) then
    msg.Result := htCaption;
end;

end.
