unit unDrzac;

interface
uses
  SysUtils, Messages, Classes, Controls, Graphics, Types, ImgList, unLinija;

type
  TDrzac = class(TCustomControl)
  private
    FSlike: TImageList;
    FImageIndex: integer;
    FAktivno: boolean;
    FOnDrzacMove: TNotifyEvent;
    FOnDrzacClick: TNotifyEvent;
    FOnDrzacFree: TNotifyEvent;
    FJunction: TList;
    FOnDeleteJunction: TNotifyEvent;
    procedure SetSlike(const Value: TImageList);
    procedure SetImageIndex(const Value: integer);
    procedure SetAktivno(const Value: boolean);
    procedure SetOnDrzacMove(const Value: TNotifyEvent);
    procedure SetOnDrzacClick(const Value: TNotifyEvent);
    procedure SetOnDrzacFree(const Value: TNotifyEvent);
    procedure SetOnDeleteJunction(const Value: TNotifyEvent);
    { Private declarations }
  protected
    { Protected declarations }
    MDown: boolean;
    nX, nY: integer;
    procedure WMWindowPosChanged(var Message: TWMWindowPosChanged); message WM_WINDOWPOSCHANGED;
  public
    { Public declarations }
    LinIn: TLinija;
    LinOut: TLinija;
    constructor Create(AOwner: TComponent); override;
    function GetCentarXY: TPoint;
    procedure Paint; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    destructor Destroy; override;
    procedure AddJunction(j: TObject);
    procedure DeleteJunction(j: TObject);
    function GetJunctionList: TList;
  published
    { Published declarations }
    property Slike: TImageList read FSlike write SetSlike;
    property ImageIndex: integer read FImageIndex write SetImageIndex;
    property Aktivno: boolean read FAktivno write SetAktivno;
    property OnDrzacMove: TNotifyEvent read FOnDrzacMove write SetOnDrzacMove;
    property OnDrzacClick: TNotifyEvent read FOnDrzacClick write SetOnDrzacClick;
    property OnDrzacFree: TNotifyEvent read FOnDrzacFree write SetOnDrzacFree;
    property OnDeleteJunction: TNotifyEvent read FOnDeleteJunction write SetOnDeleteJunction;
  end;

procedure Register;

implementation


procedure Register;
begin
  RegisterComponents('CSMP', [TDrzac]);
end;

{ TDrzac }

procedure TDrzac.DeleteJunction(j: TObject);
var
  i: integer;
begin
  i := FJunction.IndexOf(j);
  if i > -1 then
  begin
    FJunction.Delete(i);
  end;
end;

procedure TDrzac.SetOnDeleteJunction(const Value: TNotifyEvent);
begin
  FOnDeleteJunction := Value;
end;

function TDrzac.GetJunctionList: TList;
begin
  if FJunction.Count > 0 then Result := FJunction else Result := nil;
end;

procedure TDrzac.AddJunction(j: TObject);
begin
  FJunction.Add(j);
end;

destructor TDrzac.Destroy;
begin
  if Assigned(OnDrzacFree) then OnDrzacFree(self);
  FJunction.Free;
  inherited;
end;


function TDrzac.GetCentarXY: Tpoint;
begin
  Result.X := Self.Left + 5;
  Result.Y := Self.Top + 5;
end;

constructor TDrzac.Create(AOwner: TComponent);
begin
  inherited;
  SetBounds(0, 0, 8, 8);
  Aktivno := true;
  nX := 0;
  nY := 0;
  mDown := false;
  LinIn := nil;
  LinOut := nil;
  FJunction := TList.Create;
end;

procedure TDrzac.MouseDown(Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
begin
  inherited;
  if ssLeft in Shift then
  begin
    self.BringToFront;
    MDown := true;
    nX := x;
    nY := y;
  end;
  if not Aktivno then
    Aktivno := true;
  if Assigned(OnDrzacClick) then OnDrzacClick(Self);
end;

procedure TDrzac.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
  inherited;
  if MDown then
  begin
    Top := Top + Y - nY;
    Left := Left + X - nx;
  end;
end;

procedure TDrzac.MouseUp(Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
begin
  inherited;
  MDown := false;
end;

procedure TDrzac.Paint;
var
  pomr: TRect;
begin
  inherited;
  canvas.Brush.Style := bsSolid;
  pomr := GetClientRect;
  canvas.Pen.Width := 1;
  if FJunction.Count > 0 then
  begin
    canvas.Brush.Color := clBlack;
    Offsetrect(pomr, 2, 3);
    pomr.Right := pomr.Right - 3;
    pomr.Bottom := pomr.Bottom - 3;
    canvas.Ellipse(pomr);
    canvas.Brush.Style := bsClear;
    if imageindex = 1 then
    begin
      Canvas.Brush.Color := $00F2F2F2;
      Offsetrect(pomr, 1, 1);
      pomr.Right := pomr.Right - 2;
      pomr.Bottom := pomr.Bottom - 2;
      canvas.Ellipse(pomr);
    end;
  end else
  begin
    canvas.Brush.Style := bsClear;
    pomr := GetClientRect;
    OffsetRect(pomr, 2, 3);
    pomr.Right := pomr.Right - 3;
    pomr.Bottom := pomr.Bottom - 3;
    if imageindex = 1 then
    begin
      canvas.Pen.Width := 2;
      Offsetrect(pomr, 1, 1);
      pomr.Right := pomr.Right - 1;
      pomr.Bottom := pomr.Bottom - 1;
    end
    else
      canvas.Pen.Width := 1;
    canvas.Rectangle(pomr);
  end;
end;

procedure TDrzac.SetAktivno(const Value: boolean);
begin
  if FAktivno <> Value then
  begin
    FAktivno := Value;
    if FAktivno then
      SetImageIndex(1) else SetImageIndex(0);
    Invalidate;
  end;
end;

procedure TDrzac.SetImageIndex(const Value: integer);
begin
  FImageindex := value;
end;

procedure TDrzac.SetSlike(const Value: TImageList);
begin
  FSlike := Value;
end;

procedure TDrzac.WMWindowPosChanged(var Message: TWMWindowPosChanged);
begin
  inherited;
  if assigned(OnDrzacmove) then
    OnDrzacmove(self);
end;

procedure TDrzac.SetOnDrzacMove(const Value: TNotifyEvent);
begin
  FOnDrzacMove := Value;
end;

procedure TDrzac.SetOnDrzacFree(const Value: TNotifyEvent);
begin
  FOnDrzacFree := Value;
end;

procedure TDrzac.SetOnDrzacClick(const Value: TNotifyEvent);
begin
  FOnDrzacClick := Value;
end;

end.

