unit unLineEx;

interface
uses
{$IFDEF USE_CS}
  CSIntf,
{$ENDIF}
  Windows, Classes, Dialogs, Controls, Graphics, Messages, SysUtils, unLine;

type TLineEx = class(TLine)
  private
    FTip: Byte;
    FKrugColor: TColor;
  protected
    SA: TShowArrows;
    procedure SetTip(Value: Byte); virtual;
    procedure SetKrugColor(Value: TColor); virtual;
    procedure Paint; override;
    procedure WMErase(var msg:TMessage);message WM_ERASEBKGND;
  published
    property Tip: Byte // 1 za pocetnu (kruzic na pocetku), 2 za srednju (bez icega)
                       // 3 za krajnju liniju (strelica na kraju)
                       // 4 za liniju bez drzaca dakle i krug i strelica
    read FTip
      write SetTip
      default 1;
    property KrugColor: TColor
      read FKrugColor
      write SetKrugColor
      default clBlack;
  public
    constructor Create(AOwner: TComponent); override;
  end;

procedure Register;

implementation

constructor TLineEx.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;


procedure TLineEx.SetKrugColor(Value: TColor);
begin
  if FKrugColor <> Value then
  begin
    FKrugColor := Value;
    Invalidate;
  end;
end;

procedure TLineEx.SetTip(Value: Byte);
begin
  if (Value < 5) and (Value > 0) then
  begin
    FTip := Value;
    Invalidate;
  end;
end;


procedure TLineEx.Paint;
var x, y: word;
begin
  //inherited;
  if (FTip = 1) or (FTip = 2) then self.ShowArrows := saNone;
  if (FTip = 1) or (FTip = 4) then
    // crtamo kruzic na pocetku linije
  begin
    x := 7; y := 7;
    // malo perverzija ... mrzi me da komentarisem :)
    if (self.SA = saEnd) and (Self.LineSlope = lsUp) then
      y := self.Height - 13
    else
      if (self.SA = saStart) and (Self.LineSlope = lsUp) then
        x := self.Width - 13
      else
        if (self.SA = saStart) and (Self.LineSlope = lsDown) then
        begin
          y := self.Height - 13;
          x := self.Width - 13;
        end;

    Canvas.Brush.Style := bsClear;
    Canvas.Pen.Color := FKrugColor;
    Canvas.Ellipse(x+1, y+1, x + 6, y + 6);
  end;

  inherited;
end;

procedure Register;
begin
  // ovo je ako resite da instalirate LineEx kao komponentu, cisto da
  // vidite male dva dodatka Tip i KrugColor koji su ubaceni u LineEx
  // Tip sam napisao gore sta oznacava, a KrugColor je Color kruga (kruzica) :)
  RegisterComponents('CSMP', [TLineEx]);
end;

procedure TLineEx.WMErase(var msg: TMessage);
begin
  msg.Result:=1;
end;

end.

