unit unLinija;

interface
uses
  Classes, Graphics, Dialogs, unLineEx, Types, Controls, unLine;

type TLinija = class(TLineEx)
  private
    FBoja: TColor;
    FSP : TPoint;
    FEP : TPoint;
    FSelected: Boolean;
  protected
  published
  public
    constructor Create(AOwner: TComponent); override;
    function GetSelektovan: Boolean;
    function GetSP : TPoint;
    function GetEP : TPoint;
    procedure SetSelektovan(Value: Boolean);
    procedure SetSEP(sp, ep: TPoint);
    procedure SetBoja(C: TColor);
  end;

implementation

constructor TLinija.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  self.Tip := 4;
  self.SetBoja(clBlack);
  FSelected := false;
end;

function TLinija.GetSelektovan: Boolean;
begin
  Result := FSelected;
end;


procedure TLinija.SetSelektovan(Value: Boolean);
begin
  if FSelected <> Value then
  begin
    FSelected := Value;
    if FSelected then Self.LineStyle := psDot else Self.LineStyle := psSolid;
  end;
end;

procedure TLinija.SetBoja(C: TColor);
begin
  FBoja := C;
  KrugColor := FBoja;
  LineColor := FBoja;
end;

procedure TLinija.SetSEP(sp, ep: TPoint);
  procedure Swap(var A, B: Integer);
  var
    Temp: Integer;
  begin
    Temp := A;
    A := B;
    B := Temp;
  end;
begin
  FSP := sp;
  FEP := ep;
  LineSlope := lsDown;
  ShowArrows := saEnd;
  if (sp.x > ep.X) and (sp.Y <= ep.Y) then
  begin
    LineSlope := lsUp;
    ShowArrows := saStart;
    Swap(sp.x, ep.x);
  end;
  if (sp.X > ep.X) and (sp.Y > ep.Y) then
  begin
    LineSlope := lsDown;
    ShowArrows := saStart;
    Swap(sp.y, ep.y);
    Swap(sp.x, ep.x);
  end;
  if (sp.X <= ep.X) and (sp.Y > ep.Y) then
  begin
    LineSlope := lsUp;
    ShowArrows := saEnd;
    Swap(sp.y, ep.y);
  end;
  SA := ShowArrows;
  Left := sp.X - 10;
  Top := sp.Y - 10;
  Width := ep.X - Left + 10;
  Height := ep.Y - Top + 10;
end;

function TLinija.GetSP : TPoint;
begin
  result := self.FSP;
end;

function TLinija.GetEP : TPoint;
begin
  result := self.FEP;
end;


end.

