unit unVeza;

interface
uses
  Dialogs, unLinija, unDrzac, Classes, Controls, Types, Graphics, SysUtils, Contnrs;

type PDrzac = TDrzac;
  PLinija = TLinija;
  TStanja = (stNone, stKreirajDrzac, stPripremiZaJunction, stKreirajJunction,stucitajdrzac);

type

  TVeza = class(TObject)
  private
    LLinija: TList;
    FBoja: TColor;
    FStanje: TStanja;
    sp: TPoint;
    ep: TPoint;
    C: TWinControl;
    FDrzaci: TImageList;
    FDrzacKreiran: TNotifyEvent;
    FSelectedDrzac: TDrzac; // ovo je aktivni drzac (selektovani)
    FLastDrzac: TDrzac; // dok je ovo poslednje kliknuti drzac u vezi (zbog JUNCTION-a)
    //FSelectedJunction: TVeza;
    FOnSelektVeza: TNotifyEvent;
    FOnDeselectVeza: TNotifyEvent;
    FOnSelektDrzac: TNotifyEvent;
    FOnDeselectDrzac: TNotifyEvent;
    FSelektovano: boolean;
    FOnBrisanjeI: TNotifyEvent;
    FOnBrisanjeU: TNotifyEvent;
    FOnDeselectJunction: TNotifyEvent;
    FOnSelectJunction: TNotifyEvent;
    FIsJunction: boolean;
    FOnBrisiJunction: TNotifyEvent;
    FOnDrzacFree: TNotifyEvent;
    FOnMouseClickEx: TNotifyEvent;
    FPocBlok: TObject;
    FKrajBlok: TObject;
    FOnChange: TNotifyEvent;
    procedure DrzacFree(Sender: TObject);

    function NadjiIndexL(l: PLinija): integer;
    function NadjiIndexD(d: PDrzac): integer;
    function VratiIndexDrzacaUKojiUvire(pl: PLinija): Integer;
    function DaLiKreiratiDrzac(pos: TPoint): Boolean;
    procedure RefreshLinija;

    procedure SetDrzacKreiran(const Value: TNotifyEvent);

    procedure DrzacClick(Sender: TObject);
    procedure SetOnSelektVeza(const Value: TNotifyEvent);
    procedure SetOnDeselectVeza(const Value: TNotifyEvent);
    procedure SetOnSelektDrzac(const Value: TNotifyEvent);
    procedure SetOnDeselectDrzac(const Value: TNotifyEvent);
    procedure SetSelektovano(const Value: boolean);
    procedure SetOnBrisanjeI(const Value: TNotifyEvent);
    procedure SetOnBrisanjeU(const Value: TNotifyEvent);
    procedure SetOnDeselectJunction(const Value: TNotifyEvent);
    procedure SetOnSelectJunction(const Value: TNotifyEvent);
    procedure SetOnBrisiJunction(const Value: TNotifyEvent);
    procedure SetIsJunction(const Value: Boolean);
    procedure SetOnMouseClickEx(const Value: TNotifyEvent);
    procedure SetOnDrzacFree(const Value: TNotifyEvent);
    procedure SetStanje(const Value: TStanja);
    procedure SetKrajBlok(const Value: TObject);
    procedure SetPocBlok(const Value: TObject);
    procedure SetOnChange(const Value: TNotifyEvent);

  public
    Parent:TVeza;
    LDrzaca: TList;
    procedure Paint;
    procedure SelektovanJunction(Sender: TObject);
    procedure DeSelektovanJunction(Sender: TObject);
    procedure BrisiJunction(sender: TObject);
    procedure KreirajDrzac(p:TPoint);
    constructor Create(imglstDrzaci: TImageList; ICanvas: TWinControl; sp, ep: TPoint);
    procedure ObrisiDrzacM(Dr:TDrzac);
    procedure SetColor(C: TColor);
    procedure SetSEP(sp, ep: TPoint);
    procedure SetSP(sp: TPoint);
    procedure SetEP(ep: TPoint);
    function Selected: Boolean;
    procedure ObrisiSelektovanDrzac;
    procedure UnSelectAll;
    procedure UnSelectAllExcept(d: PDrzac); overload;
    procedure UnSelectAllExcept(junc: TVeza); overload;
    procedure SelectLinije;
    procedure DrzacSeMrdnuo(sender: TObject);
    destructor Destroy; override;
    function GetSelectedDrzac: TDrzac;
    procedure KreirajJunction(ep1: TPoint);
    function GetLastDrzac: TDrzac;
    procedure MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure DeleteJunction(j:TVeza);

  published
    property Selektovano: boolean read FSelektovano write SetSelektovano;
    property IsJunction: boolean read FIsJunction write SetIsJunction;
    property DrzacKreiran: TNotifyEvent read FDrzacKreiran write SetDrzacKreiran;
    property OnSelektVeza: TNotifyEvent read FOnSelektVeza write SetOnSelektVeza;
    property OnDeselectVeza: TNotifyEvent read FOnDeselectVeza write SetOnDeselectVeza;
    property OnSelektDrzac: TNotifyEvent read FOnSelektDrzac write SetOnSelektDrzac;
    property OnDeselectDrzac: TNotifyEvent read FOnDeselectDrzac write SetOnDeselectDrzac;
    property OnBrisanjeU: TNotifyEvent read FOnBrisanjeU write SetOnBrisanjeU;
    property OnBrisanjeI: TNotifyEvent read FOnBrisanjeI write SetOnBrisanjeI;
    property OnSelectJunction: TNotifyEvent read FOnSelectJunction write SetOnSelectJunction;
    property OnDeSelectJunction: TNotifyEvent read FOnDeSelectJunction write SetOnDeSelectJunction;
    property OnBrisiJunction: TNotifyEvent read FOnBrisiJunction write SetOnBrisiJunction;
    property OnMouseClickEx: TNotifyEvent read FOnMouseClickEx write SetOnMouseClickEx;
    property OnDrzacFree: TNotifyEvent read FOnDrzacFree write SetOnDrzacFree;
    property Stanje: TStanja read FStanje write SetStanje;
    property PocBlok: TObject read FPocBlok write SetPocBlok;
    property KrajBlok: TObject read FKrajBlok write SetKrajBlok;
    property OnChange: TNotifyEvent read FOnChange write SetOnChange;
  end;

implementation

function TVeza.Selected: Boolean;
begin
  Result := Selektovano;
  Paint;
end;

procedure TVeza.SetStanje(const Value: TStanja);
begin
  FStanje := Value;
end;

procedure TVeza.SetIsJunction(const Value: Boolean);
begin
  FIsJunction := Value;
end;

function TVeza.GetSelectedDrzac: TDrzac;
begin
  result := FSelectedDrzac;
end;

procedure TVeza.SetOnDrzacFree(const Value: TNotifyEvent);
begin
  FOnDrzacFree:=Value;
end;

procedure TVeza.SetOnMouseClickEx(const Value: TNotifyEvent);
begin
  FOnMouseClickEx := Value;
end;

function TVeza.GetLastDrzac: TDrzac;
begin
  result := FLastDrzac;
end;

procedure TVeza.KreirajJunction(ep1: TPoint);
var junc: TVeza;
begin
  if (FLastDrzac <> nil) then
  begin
    junc := TVeza.Create(nil, c, FLastDrzac.GetCentarXY, ep1);
    junc.SetSelektovano(false);
    junc.IsJunction := true;
    junc.OnSelectJunction := SelektovanJunction;
    junc.OnDeSelectJunction := DeSelektovanJunction;
    junc.SetColor(clBlack);
    junc.Parent:=self;
    FLastDrzac.AddJunction(TObject(junc));
    FLastDrzac.OnDeleteJunction := BrisiJunction;
  end;
end;

procedure TVeza.SelektovanJunction(Sender: TObject);
begin
  if Sender is TVeza then
    if TVeza(Sender).IsJunction then
    begin
      UnSelectAllExcept(TVeza(sender));
    end;
  if assigned(OnSelectJunction) then
    OnSelectJunction(self);
end;

procedure TVeza.DeSelektovanJunction(Sender: TObject);
begin
  if assigned(OnDeSelectJunction) then OnDeSelectJunction(self);
end;

procedure TVeza.DeleteJunction(j: TVeza);
var
  i : integer;
begin
  if LDrzaca.Count>0 then
  for i:=LDrzaca.Count-1 downto 0 do
  begin
    TDrzac(LDrzaca.Items[i]).DeleteJunction(TObject(j));
  end;
  LDrzaca.Pack;
end;

procedure TVeza.DrzacFree(Sender: TObject);
begin
  if Sender is TDrzac then
  begin
    if Assigned(OnDrzacFree) then OnDrzacFree(Sender);
  end;
end;

procedure TVeza.DrzacClick(Sender: TObject);
var sign: boolean;
begin
  if stanje = stPripremiZaJunction then stanje := stKreirajJunction;
  sign := TDrzac(Sender).Aktivno;
  FLastDrzac := TDrzac(Sender);
  if sign then
  begin
    if FSelectedDrzac <> nil then
      FSelectedDrzac.Aktivno := false;
    FSelectedDrzac := TDrzac(Sender);
    UnSelectAllExcept(FSelectedDrzac);
    if assigned(OnSelektDrzac) then
      OnSelektDrzac(self);
  end else
  begin
    FSelectedDrzac := nil;
    if assigned(OnDeselectDrzac) then
      OnDeselectDrzac(self);
  end;
end;

procedure TVeza.ObrisiSelektovanDrzac;
var pd, pdtmp: PDrzac;
  pl: PLinija;
  i: word;
begin
  if (LDrzaca.Count > 0) and (FSelectedDrzac <> nil) then
  begin
    i := NadjiIndexD(FSelectedDrzac);
    pd := PDrzac(LDrzaca.Items[i]);
    pl := pd.LinOut;
    if VratiIndexDrzacaUKojiUvire(pl) <> -1 then
    begin
      pdtmp := PDrzac(LDrzaca.Items[VratiIndexDrzacaUKojiUvire(pl)]);
      pdtmp.LinIn := pd.LinIn;
      pd.LinIn.SetSEP(pd.LinIn.GetSP, pdtmp.GetCentarXY);
    end else
    begin
      pd.LinIn.SetSEP(pd.LinIn.GetSP, self.ep);
      if (pd.LinIn.GetSP.X = self.sp.X) and (pd.LinIn.GetSP.Y = self.sp.Y) then pd.LinIn.Tip := 4 else pd.LinIn.Tip := 3;
    end;

    pd.OnDrzacClick := nil;
    pd.OnDrzacMove := nil;
    LDrzaca.Delete(i);
    LLinija.Delete(NadjiIndexL(pl));
    pd.Destroy;
    pl.Free;
    FSelectedDrzac := nil;
  end;
end;
//Milos menjao mnogo
procedure TVeza.RefreshLinija;
var i: word;
  start: TPoint;
  pl: PLinija;
  pd: PDrzac;
  function uporedi(t1,t2:TPoint):boolean;
  begin
    if (t1.x=t2.X) and (t1.y=t2.y) then
      result:=true
    else
      result:=false;
  end;
begin
  if LDrzaca.Count > 0 then
  begin
    start := self.sp;
    for i := 0 to LDrzaca.Count - 1 do
    begin
      pd := PDrzac(LDrzaca.Items[i]);
      pl := pd.LinIn;
      if not (uporedi(pl.GetSP,start) and uporedi(pl.GetEP,pd.GetCentarXY)) then
      begin
        pl.SetSEP(start, pd.GetCentarXY);
        pl.SetSelektovan(Selektovano);
        pl.SetBoja(FBoja);
        pl.Refresh;
      end;
      start := pd.GetCentarXY;
    end;
    pl := pd.LinOut;
    if not (uporedi(pl.GetSP,start) and uporedi(pl.GetEP,self.ep)) then
    begin
      pl.SetSEP(start, self.ep);
      pl.SetSelektovan(Selektovano);
      pl.SetBoja(FBoja);
      pl.Refresh;
    end;
  end else
  begin
    pl := PLinija(LLinija.Items[0]);
    pl.SetSEP(self.sp, self.ep);
    pl.SetBoja(FBoja);
    pl.Refresh;
  end;
end;
// Kraj Milos menjao

function TVeza.DaLiKreiratiDrzac(pos: TPoint): Boolean;
var i: word;
  pd: PDrzac;
  R, R1, R2: TRect;
begin
  R1.Left := pos.X - 6;
  R1.Top := pos.Y - 6;
  R1.Right := pos.X + 18;
  R1.Bottom := pos.Y + 18;
  Result := True;
  if LDrzaca.Count > 0 then
    for i := 0 to LDrzaca.Count - 1 do
    begin
      pd := PDrzac(LDrzaca.Items[i]);
      R2.Left := pd.Left;
      R2.Top := pd.Top;
      R2.Right := pd.Left + 12;
      R2.Bottom := pd.Top + 12;
      Result := not (IntersectRect(R, R1, R2));
      if Result = False then Break;
    end;
end;

function TVeza.VratiIndexDrzacaUKojiUvire(pl: PLinija): Integer;
var i: word;
  pd: PDrzac;
begin
  Result := -1;
  if LDrzaca.Count > 0 then
    for i := 0 to LDrzaca.Count - 1 do
    begin
      pd := PDrzac(LDrzaca.Items[i]);
      if pd.LinIn = pl then
      begin
        Result := i;
        break;
      end;
    end;
end;

function TVeza.NadjiIndexL(l: PLinija): integer;
var i: word;
  pl: PLinija;
begin
  Result := -1;
  if LLinija.Count > 0 then
    for i := 0 to LLinija.Count - 1 do
    begin
      pl := PLinija(LLinija.Items[i]);
      if pl = l then result := i;
    end;
end;

function TVeza.NadjiIndexD(d: PDrzac): integer;
var i: word;
  pd: PDrzac;
begin
  Result := -1;
  if LDrzaca.Count > 0 then
    for i := 0 to LDrzaca.Count - 1 do
    begin
      pd := PDrzac(LDrzaca.Items[i]);
      if pd = d then result := i;
    end;
end;


procedure TVeza.MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var i, k: word;
  d, pdtmp: PDrzac;
  pos: Tpoint;
  pl, ptmp: PLinija;
begin
  if mbRight = Button then
    if Assigned(OnMouseClickEx) then
    begin
      OnMouseClickEx(Self);
      exit;
    end;

  if TLinija(Sender).GetSelektovan then
  begin
    UnSelectAll;
    Selektovano := False;
  end else
    SelectLinije; // selektuje Liniju i stavlja Selektovano na true
  for i := 0 to LLinija.Count - 1 do
  begin
    pl := PLinija(LLinija.Items[i]);
    pl.SetSelektovan(Selektovano);
  end;
  pos.X := x - 6 + TLinija(Sender).Left;
  pos.Y := y - 6 + TLinija(Sender).Top;
  if ((Stanje = stPripremiZaJunction) or (Stanje = stKreirajDrzac) {or (stanje = stucitajdrzac)}) and (DaLiKreiratiDrzac(pos)) then
  begin
    d := nil;
    d := TDrzac.Create(C);
    d.Parent := C;
    d.OnDrzacMove := DrzacSeMrdnuo;
    d.OnDrzacClick := DrzacClick;
    d.OnDrzacFree := DrzacFree;
    d.Slike := FDrzaci;
    d.Aktivno := false;
    d.Left := pos.x;
    d.Top := pos.y;
    d.LinIn := TLinija(Sender);

    pl := nil;
    pl := TLinija.Create(C);
    pl.Parent := C;
    pl.SetSelektovan(Selektovano);
    pl.SetSEP(d.GetCentarXY, TLinija(Sender).GetEP);
    TLinija(Sender).SetSEP(TLinija(Sender).GetSP, d.GetCentarXY);

    // Sredjivanje linije koja se cepa ...
    case TLinija(Sender).Tip of
      4: begin pl.Tip := 3; TLinija(Sender).Tip := 1; end;
      3: begin pl.tip := 3; TLinija(Sender).Tip := 2; end;
      2: begin pl.tip := 2; TLinija(Sender).Tip := 2; end;
      1: begin pl.tip := 2; TLinija(Sender).Tip := 1; end;
    end;

    pl.SetBoja(FBoja);
    pl.OnMouseUp := MouseUp;
    ptmp := TLinija(Sender);
    LLinija.Insert(NadjiIndexL(ptmp) + 1, pl);

    d.LinOut := pl;
    if VratiIndexDrzacaUKojiUvire(ptmp) <> -1 then
    begin
      k := VratiIndexDrzacaUKojiUvire(ptmp);
      pdtmp := PDrzac(LDrzaca.Items[k]);
      pdtmp.LinIn := pl;
      LDrzaca.Insert(k, d);
    end else LDrzaca.Add(d);
    UnselectAll;
    if Stanje = stPripremiZaJunction then
    begin
      FLastDrzac := d;
      Stanje := stKreirajJunction;
    end;
    if assigned(Drzackreiran) {and (stanje<>stucitajdrzac)} then
      DrzacKreiran(self);
  end;
end;

procedure TVeza.UnSelectAllExcept(junc: TVeza);
var i: word;
  pl: PLinija;
  pd: PDrzac;
begin
  FSelectedDrzac := nil;
  Selektovano := false;
  if LLinija.Count > 0 then
    for i := 0 to LLinija.Count - 1 do
    begin
      pl := PLinija(LLinija.Items[i]);
      pl.SetSelektovan(Selektovano);
    end;
  if LDrzaca.Count > 0 then
    for i := 0 to LDrzaca.Count - 1 do
    begin
      pd := PDrzac(LDrzaca.Items[i]);
      pd.Aktivno := Selektovano;
    end;
end;

procedure TVeza.UnSelectAllExcept(d: PDrzac);
var i: word;
  pl: PLinija;
  pd: PDrzac;
begin
  Selektovano := false;
  if LLinija.Count > 0 then
    for i := 0 to LLinija.Count - 1 do
    begin
      pl := PLinija(LLinija.Items[i]);
      pl.SetSelektovan(Selektovano);
    end;
  if LDrzaca.Count > 0 then
    for i := 0 to LDrzaca.Count - 1 do
    begin
      pd := PDrzac(LDrzaca.Items[i]);
      if pd <> d then pd.Aktivno := Selektovano;
    end;
  FSelectedDrzac := d;
  FLastDrzac := d;
end;

procedure TVeza.UnSelectAll;
var i: word;
  pl: PLinija;
  pd: PDrzac;
begin
  FSelectedDrzac := nil;
  Selektovano := false;
  if LLinija.Count > 0 then
    for i := 0 to LLinija.Count - 1 do
    begin
      pl := PLinija(LLinija.Items[i]);
      pl.SetSelektovan(Selektovano);
    end;
  if LDrzaca.Count > 0 then
    for i := 0 to LDrzaca.Count - 1 do
    begin
      pd := PDrzac(LDrzaca.Items[i]);
      pd.Aktivno := Selektovano;
    end;
end;

procedure TVeza.SelectLinije;
var i: word;
  pl: PLinija;
  pd: PDrzac;
begin
  FSelectedDrzac := nil;
  Selektovano := true;
  if LLinija.Count > 0 then
    for i := 0 to LLinija.Count - 1 do
    begin
      pl := PLinija(LLinija.Items[i]);
      pl.SetSelektovan(Selektovano);
    end;
  if LDrzaca.Count > 0 then
    for i := 0 to LDrzaca.Count - 1 do
    begin
      pd := PDrzac(LDrzaca.Items[i]);
      pd.Aktivno := false;
    end;
end;

procedure TVeza.SetColor(C: TColor);
begin
  if (FBoja <> C) then
  begin
    FBoja := C;
    Paint;
  end;
end;

procedure TVeza.SetSEP(sp, ep: TPoint);
begin
  if (sp.X <> self.sp.X) or (sp.Y <> self.sp.Y) then
  begin
    self.sp := sp;
    Paint;
  end;
  if (ep.X <> self.ep.X) or (ep.Y <> self.ep.Y) then
  begin
    self.ep := ep;
    Paint;
  end;
end;

procedure TVeza.Paint;
begin
  RefreshLinija;
end;

constructor TVeza.Create(imglstDrzaci: TImageList; ICanvas: TWinControl; sp, ep: TPoint);
var v: PLinija;
begin
  // kreiraj Veza i postavi default vrednosti
  // neselektovana i crna linija

  Selektovano := false;
  SetColor(clBlack);
  // init liste drzaca i linija
  LDrzaca := TList.Create;
  LLinija := TList.Create;
  FIsJunction := False;
  // pocetna i krajnja tacka veze
  self.sp := sp;
  self.ep := ep;
  // Parent object
  C := ICanvas;
  // kreiranje prve linije
  v := nil;
  v := TLinija.Create(ICanvas);
  v.Parent := ICanvas;
  v.SetBoja(FBoja);
  v.OnMouseUp := MouseUp;
  v.SetSEP(sp, ep);
  LLinija.Add(v);
  FDrzaci := imglstDrzaci;
  Stanje := stNone;
  FSelectedDrzac := nil;
//  FSelectedJunction := nil;
end;

procedure TVeza.BrisiJunction(sender: TObject);
begin
  if Assigned(OnBrisiJunction) then OnBrisiJunction(sender);
end;

destructor TVeza.Destroy;
var i, j: word;
  pd: PDrzac;
  pl: PLinija;
begin
  if Assigned(OnBrisanjeU) then
    OnBrisanjeU(self);

  if Assigned(OnBrisanjeI) then
    OnBrisanjeI(self);
  j := LDrzaca.Count;
  if j = 0 then
    pl := PLinija(LLinija.Items[0])
  else
  begin
    for i := 0 to j - 1 do
    begin
      pd := PDrzac(LDrzaca.Items[0]);
      pd.OnDrzacMove := nil;
      pd.LinIn.Free;
      pl := pd.LinOut;
      LDrzaca.Delete(0);
      pd.Free;
    end;
  end;
  pl.Free;
  LDrzaca.Free;
  LLinija.Free;

  inherited;
end;

procedure TVeza.SetSP(sp: TPoint);
begin
  if (sp.X <> self.sp.X) or (sp.Y <> self.sp.Y) then
  begin
    self.sp := sp;
    Paint;
  end;
end;

procedure TVeza.SetEP(ep: TPoint);
begin
  if (ep.X <> self.ep.X) or (ep.Y <> self.ep.Y) then
  begin
    self.ep := ep;
    Paint;
  end;
end;

procedure TVeza.DrzacSeMrdnuo(sender: TObject);
var i: integer;
  l: TList;
begin
  if sender is TDrzac then
  begin
    l := TDrzac(Sender).GetJunctionList;
    if l <> nil then
      for i := 0 to l.Count - 1 do
        TVeza(l.Items[i]).SetSP(TDrzac(Sender).GetCentarXY);
    //*** KOSTA ****\\
    if Assigned(OnChange) then
      OnChange(Self);
  end;
  paint;
end;

procedure TVeza.SetDrzacKreiran(const Value: TNotifyEvent);
begin
  FDrzacKreiran := Value;
end;

procedure TVeza.SetOnSelektVeza(const Value: TNotifyEvent);
begin
  FOnSelektVeza := Value;
end;

procedure TVeza.SetOnDeselectVeza(const Value: TNotifyEvent);
begin
  FOnDeselectVeza := Value;
end;

procedure TVeza.SetOnSelektDrzac(const Value: TNotifyEvent);
begin
  FOnSelektDrzac := Value;
end;

procedure TVeza.SetOnBrisiJunction(const Value: TNotifyEvent);
begin
  FOnBrisiJunction := Value;
end;

procedure TVeza.SetOnDeselectDrzac(const Value: TNotifyEvent);
begin
  FOnDeselectDrzac := Value;
end;

procedure TVeza.SetOnDeselectJunction(const Value: TNotifyEvent);
begin
  FOnDeselectJunction := Value;
end;

procedure TVeza.SetOnSelectJunction(const Value: TNotifyEvent);
begin
  FOnSelectJunction := Value;
end;

procedure TVeza.SetSelektovano(const Value: boolean);
begin
  FSelektovano := Value;
  if not FSelektovano then
  begin
    if self.IsJunction then
    begin
      if assigned(OnDeSelectJunction) then OnDeSelectJunction(self);
    end else
      if assigned(OnDeselectVeza) then
        OnDeselectVeza(self);
  end else
  begin
    FSelectedDrzac := nil;
    if not (self.IsJunction) then
    begin
//      FSelectedJunction := nil;
      if assigned(OnSelektVeza) then
        OnSelektVeza(self);
    end else
      if self.IsJunction then
      begin
//        FSelectedJunction := self;
        if assigned(OnSelectJunction) then OnSelectJunction(self);
      end;
  end;
end;

procedure TVeza.SetOnBrisanjeI(const Value: TNotifyEvent);
begin
  FOnBrisanjeI := Value;
end;

procedure TVeza.SetOnBrisanjeU(const Value: TNotifyEvent);
begin
  FOnBrisanjeU := Value;
end;

procedure TVeza.SetKrajBlok(const Value: TObject);
begin
  FKrajBlok := Value;
end;

procedure TVeza.SetPocBlok(const Value: TObject);
begin
  FPocBlok := Value;
end;

procedure TVeza.ObrisiDrzacM(Dr: TDrzac);
var pd, pdtmp: PDrzac;
  pl: PLinija;
  i: word;
begin
  if (LDrzaca.Count > 0) and (dr <> nil) then
  begin
    i := NadjiIndexD(dr);
    pd := PDrzac(LDrzaca.Items[i]);
    pl := pd.LinOut;
    if VratiIndexDrzacaUKojiUvire(pl) <> -1 then
    begin
      pdtmp := PDrzac(LDrzaca.Items[VratiIndexDrzacaUKojiUvire(pl)]);
      pdtmp.LinIn := pd.LinIn;
      pd.LinIn.SetSEP(pd.LinIn.GetSP, pdtmp.GetCentarXY);
    end else
    begin
      pd.LinIn.SetSEP(pd.LinIn.GetSP, self.ep);
      if (pd.LinIn.GetSP.X = self.sp.X) and (pd.LinIn.GetSP.Y = self.sp.Y) then pd.LinIn.Tip := 4 else pd.LinIn.Tip := 3;
    end;

    pd.OnDrzacClick := nil;
    pd.OnDrzacMove := nil;
    LDrzaca.Delete(i);
    LLinija.Delete(NadjiIndexL(pl));
    pd.Destroy;
    pl.Free;
    FSelectedDrzac := nil;
    if flastdrzac=dr then flastdrzac:=nil;
  end;
end;

procedure TVeza.KreirajDrzac(p: TPoint);
var
  oldst:TStanja;
  pt:tpoint;
begin
  oldst := self.Stanje;
  self.Stanje := stKreirajDrzac;
  pt.X:=p.x-TLinija(self.LLinija.Last).Left;
  pt.y:=p.y-TLinija(self.LLinija.Last).Top;
  self.MouseUp(TLinija(self.LLinija.Last), mbLeft, [], pt.x, pt.y);
  self.Stanje := oldst;
end;

procedure TVeza.SetOnChange(const Value: TNotifyEvent);
begin
  FOnChange := Value;
end;

end.

