package com.example.milos.pecurke;
import android.app.Activity;
import android.os.Bundle;
import android.os.StrictMode;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import org.json.JSONObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
public class MainActivity extends Activity {
private TextView labelaTemp, labelaHum, labelaCo, labelaTime;
private ImageView imageTempRed, imageTempGreen, imageHumRed, imageHumGreen, imageCoRed,
imageCoGreen;
@Override
protected void onCreate(Bundle savedInstanceState) {
super.onCreate(savedInstanceState);
setContentView(R.layout.activity_main);
StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permit-
All().build();
StrictMode.setThreadPolicy(policy);
labelaTemp = (TextView) findViewById(R.id.valueTemp);
labelaHum = (TextView) findViewById(R.id.valueHum);
labelaCo = (TextView) findViewById(R.id.valueCo);
labelaTime = (TextView) findViewById(R.id.valueTime);
imageTempRed = (ImageView) findViewById(R.id.imageTempRed);
imageTempGreen = (ImageView) findViewById(R.id.imageTempGreen);
imageHumRed = (ImageView) findViewById(R.id.imageHumRed);
imageHumGreen = (ImageView) findViewById(R.id.imageHumGreen);
imageCoRed = (ImageView) findViewById(R.id.imageCoRed);
imageCoGreen = (ImageView) findViewById(R.id.imageCoGreen);
String entity =””;
String dataTemp= “”, dataHum= “”, dataCo=””, dataTime= “”;
String dataMinTemp=””, dataMaxTemp=””, dataMinHum=””, dataMaxHum=””, dataMinCo=””,
dataMaxCo=””;
try {
URL url = new URL(“http://arkom.student.elab.fon.bg.ac.rs/pecurke/services/
getAppData.php”);
HttpURLConnection urlConnection = (HttpURLConnection) url.openConnection();
InputStream in = new BufferedInputStream(urlConnection.getInputStream());
entity = readStream(in);
if(entity != null){
JSONObject respObject = new JSONObject(entity);
dataTemp = respObject.getString(“temperature”);
dataHum = respObject.getString(“humidity”);
dataCo = respObject.getString(“co”);
dataTime = respObject.getString(“time”);
dataMinTemp = respObject.getString(“minTemp”);
dataMaxTemp = respObject.getString(“maxTemp”);
dataMinHum = respObject.getString(“minHum”);
dataMaxHum = respObject.getString(“maxHum”);
dataMinCo = respObject.getString(“minCo”);
dataMaxCo = respObject.getString(“maxCo”);
}
urlConnection.disconnect();
} catch (Exception e) {
e.printStackTrace();
}
if(Integer.parseInt(dataTemp)<Integer.parseInt(dataMinTemp)
labelaTemp.setText(dataTemp.concat(“°C”));
labelaHum.setText(dataHum.concat(“%”));
labelaCo.setText(dataCo.concat(“ ppm”));
labelaTime.setText(transformDate(dataTime));
Integer.parseInt(dataTemp)>Integer.parseInt(dataMaxTemp))
{
imageTempRed.setVisibility(View.VISIBLE);
imageTempGreen.setVisibility(View.INVISIBLE);
}
else
{
imageTempRed.setVisibility(View.INVISIBLE);
imageTempGreen.setVisibility(View.VISIBLE);
}
if(Integer.parseInt(dataHum)<Integer.parseInt(dataMinHum) || Integer.parseInt(dataHum)>
Integer.parseInt(dataMaxHum))
{
imageHumRed.setVisibility(View.VISIBLE);
imageHumGreen.setVisibility(View.INVISIBLE);
}
else
{
imageHumRed.setVisibility(View.INVISIBLE);
imageHumGreen.setVisibility(View.VISIBLE);
}
if(Integer.parseInt(dataCo)<Integer.parseInt(dataMinCo) || Integer.parseInt(data-
Co)>Integer.parseInt(dataMaxCo))
{
imageCoRed.setVisibility(View.VISIBLE);
imageCoGreen.setVisibility(View.INVISIBLE); }
else
{
imageCoRed.setVisibility(View.INVISIBLE);
imageCoGreen.setVisibility(View.VISIBLE);
}
}
private String readStream(InputStream is) {
try {
ByteArrayOutputStream bo = new ByteArrayOutputStream();
int i = is.read();
while(i != -1) {
bo.write(i);
i = is.read();
}
return bo.toString();
} catch (IOException e) {
return “”;
}
}
private String transformDate(String timeStampStr){
String newDateStr = timeStampStr.substring(8,10).concat(“.”).concat(timeStampStr.substring(
5,7)).concat(“.”).concat(timeStampStr.substring(0,4)).concat(“.”).concat(-
timeStampStr.substring(10));
return newDateStr;
}
@Override
public boolean onCreateOptionsMenu(Menu menu) {
// Inflate the menu; this adds items to the action bar if it is present.
getMenuInflater().inflate(R.menu.menu_main, menu);
return true;
}
@Override
public boolean onOptionsItemSelected(MenuItem item) {
// Handle action bar item clicks here. The action bar will
// automatically handle clicks on the Home/Up button, so long
// as you specify a parent activity in AndroidManifest.xml.
int id = item.getItemId();
//noinspection SimplifiableIfStatement
if (id == R.id.action_settings) { return true; }
return super.onOptionsItemSelected(item); }
}