package elab.milica.smartagro;
import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.StrictMode;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ImageView;
import android.widget.Switch;
import android.widget.TextView;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import org.json.JSONObject;
public class MainActivity extends Activity {
	private TextView labelaTemp, labelaHum,labelaTime, labelaWatering ;
	private Switch switchButtonWatering;
	private TextView labelaForecast, labelaMaxTemp, labelaMinTemp;
	private ImageView imageViewWeather;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		StrictMode.ThreadPolicy policy =
		new StrictMode.ThreadPolicy.Builder().permitAll().build();
		StrictMode.setThreadPolicy(policy);
		labelaTemp = (TextView) findViewById(R.id.valueTemp);
		labelaHum = (TextView) findViewById(R.id.valueHum);
		labelaTime = (TextView) findViewById(R.id.valueTime);
		labelaWatering = (TextView) findViewById(R.id.valueWatering);
		labelaForecast = (TextView) findViewById(R.id.textWeatherForecast);
		labelaMaxTemp = (TextView) findViewById(R.id.maxTemp);
		labelaMinTemp = (TextView) findViewById(R.id.minTemp);
		imageViewWeather = (ImageView) findViewById(R.id.imageWeatherForecast);
		switchButtonWatering = (Switch) findViewById(R.id.switchWatering);
		String entity =””;
		String dataTemp= “”, dataHum= “”, dataTime= “”, dataWatering = “”;
		String weatherForecast= “”, weatherImageURL= “”, maxTemp= “”, minTemp= “”;
		final String username = “milica”;
		final String password = “password”;
		try {
			Authenticator.setDefault(new Authenticator() {
			protected PasswordAuthentication getPasswordAuthentication() {
			return new PasswordAuthentication(username, password.toCharArray()); }});
		URL url = new URL(“http://milica.elab.fon.bg.ac.rs/smart/services/getAppData.php”);
			HttpURLConnection urlConnection = (HttpURLConnection) url.openConnection();
			InputStream in = new BufferedInputStream(urlConnection.getInputStream());
			entity = readStream(in);
			if(entity != null){
			JSONObject respObject = new JSONObject(entity);
			dataTemp = respObject.getString(“temperature”);
			dataHum = respObject.getString(“humidity”);
			dataTime = respObject.getString(“time”);
			dataWatering = respObject.getString(“lastWatering”); }
			urlConnection.disconnect();
	url = new URL(“http://milica.elab.fon.bg.ac.rs/smart/services/getWeatherForecast.php”);
			urlConnection = (HttpURLConnection) url.openConnection();
			in = new BufferedInputStream(urlConnection.getInputStream());
			entity = readStream(in);
			if(entity != null){
				JSONObject respObject = new JSONObject(entity);
				weatherForecast = respObject.getString(“weatherDesc”);
				weatherImageURL = respObject.getString(“weatherIconUrl”);
				maxTemp = respObject.getString(“maxtempC”);
				minTemp = respObject.getString(“mintempC”); }
				urlConnection.disconnect();
			} catch (Exception e) {
				e.printStackTrace();
			}
	labelaTemp.setText(dataTemp.concat(“ C”));
			labelaHum.setText(dataHum.concat(“%”));
			labelaTime.setText(transformDate(dataTime));
			labelaWatering.setText(transformDate(dataWatering));
			labelaForecast.setText(weatherForecast);
			labelaMaxTemp.setText(maxTemp.concat(“ C”));
			labelaMinTemp.setText(minTemp.concat(“ C”));
			Bitmap bitmap = DownloadImage(weatherImageURL);
			imageViewWeather.setImageBitmap(bitmap);
			//attach a listener to check for changes in state
			switchButtonWatering.setOnCheckedChangeListener(new OnCheckedChangeListener() {
			@Override
			public void onCheckedChanged(CompoundButton buttonView,
			boolean isChecked) {
	if (isChecked) {
		try {
		URL url = new URL(“http://milica.elab.fon.bg.ac.rs/smart/services/start.php”);
		HttpURLConnection urlConnection = (HttpURLConnection) url.openConnection();
		String response = urlConnection.getResponseMessage();
		urlConnection.disconnect();
		} catch (Exception e) {
		e.printStackTrace(); }
		} else {
		try {
		URL url = new URL(“http://milica.elab.fon.bg.ac.rs/smart/services/stop.php”);
		HttpURLConnection urlConnection = (HttpURLConnection) url.openConnection();
		InputStream in = new BufferedInputStream(urlConnection.getInputStream());
		String response = readStream(in);
		urlConnection.disconnect();
		if (response != null) {
		JSONObject respObject = new JSONObject(response);
			String data = respObject.getString(“lastWatering”);
			labelaWatering.setText(transformDate(data)); }
				} catch (Exception e) {
					e.printStackTrace();
					}		
				}
			}
		});
		}
		private String readStream(InputStream is) {
		try {
		ByteArrayOutputStream bo = new ByteArrayOutputStream();
			int i = is.read();
			while(i != -1) {
				bo.write(i);
				i = is.read(); }
			return bo.toString();
		} catch (IOException e) {
		return “”; }
		}
		private String transformDate(String timeStampStr){
		String newDateStr = timeStampStr.substring(8,10).concat(“.”).concat(timeStampStr.
		substring(5,7)).concat(“.”).concat(timeStampStr.substring(0,4)).concat(timeStampStr.
		substring(10));
		return newDateStr;
		}	
		private Bitmap DownloadImage(String stringURL) {
	Bitmap bitmap = null;
		InputStream in = null;
		try {
		// in = OpenHttpConnection(URL);
		URL url = new URL(stringURL);
		HttpURLConnection urlConnection = (HttpURLConnection) url.openConnection();
		bitmap = BitmapFactory.decodeStream(urlConnection.getInputStream());
		urlConnection.disconnect();
		} catch (IOException e1) {
		// TODO Auto-generated catch block
		e1.printStackTrace(); }
		return bitmap; }
		@Override
		public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.menu_main, menu);
		return true; }
		@Override
		public boolean onOptionsItemSelected(MenuItem item) {
		int id = item.getItemId();
		if (id == R.id.action_settings) {
		return true; }
		return super.onOptionsItemSelected(item); }
		}