<?php
session_start();
?>
<!DOCTYPE html>
<html lang=”en”>
<head>
<meta charset=”utf-8”>
<meta http-equiv=”X-UA-Compatible” content=”IE=edge”>
<meta name=”viewport” content=”width=device-width, initial-scale=1”>
<!-- The above 3 meta tags *must* come first in the head; any other head content must
come *after* these tags -->
<meta name=”description” content=””>
<meta name=”author” content=””>
<link rel=”icon” href=”../../favicon.ico”>
<title>Pametna poljoprivreda</title>
<!-- Bootstrap core CSS -->
<link href=”./css/bootstrap.min.css” rel=”stylesheet”>
<!-- Bootstrap theme -->
<link href=”./css/bootstrap-theme.min.css” rel=”stylesheet”>
<link href=”./css/bootstrap-switch.css” rel=”stylesheet”>
<script src=”./js/jquery.min.js”></script>
<script type=”text/javascript”
src=”https://www.google.com/jsapi?autoload={
‘modules’:[{
‘name’:’visualization’,
‘version’:’1’,
‘packages’:[‘corechart’]
}]
}”></script>
<script type=”text/javascript”>
google.load(‘visualization’, ‘1.1’, {packages: [‘line’, ‘corechart’]});
google.setOnLoadCallback(drawChart);
function drawChart() {
var materialChart;
var materialDiv = document.getElementById(‘material’);
var data = new google.visualization.DataTable();
data.addColumn(‘string’, ‘Vreme’);
data.addColumn(‘number’, “Prosečna temperatura”);
data.addColumn(‘number’, “Prosečna vlažnost”);
<?php
include (“sensorData.php”);
?>
data.addRows(<?php echo $json_niz; ?>);
//data.addRows([[16,29.2308,31.0000]]);
var materialOptions = {
chart: {
title: ‘Podaci sa senzora (od <?php echo $start_period_date_frm; ?> do <?php
echo $end_period_date_frm; ?>)’
},
width: 900,
height: 500,
series: {
// Gives each series an axis name that matches the Y-axis below.
0: {axis: ‘Temp’},
1: {axis: ‘Humidity’}
},
axes: {
// Adds labels to each axis; they don’t have to match the axis names.
y: {
Temp: {label: ‘Temp (Celzijus)’},
Humidity: {label: ‘ Vlažnost (%)’}
}
}
};
materialChart = new google.charts.Line(materialDiv);
materialChart.draw(data, materialOptions);
}
</script>
<script type=”text/javascript”>
function clickHandler(anchor) {
var hasClass = anchor.getAttribute(‘class’);
if (hasClass !== ‘active’) {
anchor.setAttribute(‘class’, ‘active’);
}
}
</script>
<script>
function deviceCallback(json){
console.log(json);
}
$(document).ready(function(){
$(‘input[name=”pumpa”]’).on(‘switchChange.bootstrapSwitch’, function(
event, state) {
if (($(“#switch-state”).is(‘:checked’))){
$.ajax({
type: ‘GET’,
url: ‘http://milica.elab.fon.bg.ac.rs/smart/
services/start.php’,
dataType: ‘jsonp’,
success: function (data) {
console.log(data);
}
});
} else {
	$.ajax({
type: ‘GET’,
url: ‘http://milica.elab.fon.bg.ac.rs/smart/
services/stop.php’,
dataType: ‘json’,
success: function (data) {
console.log(data);
$(‘#poslednjeZalivanje’).html(data.lastWatering_frm);
}
});
}
});
});
</script>
</head>
<body role=”document” style=”padding-top:50px”>
<?php
include(‘postRequests.php’);
?>
<nav class=”navbar navbar-default navbar-fixed-top” role=”navigation”>
<div class=”container”>
<div class=”navbar-header”>
<button type=”button” class=”navbar-toggle collapsed” data-toggle=”collapse”
data-target=”//navbar-collapsible”>
<span class=”sr-only”>Toggle navigation</span>
<span class=”icon-bar”></span>
<span class=”icon-bar”></span>
<span class=”icon-bar”></span>
</button>
<a class=”navbar-brand text-danger” href=”//start”>Pametna poljoprivreda</a>
</div>
<div class=”navbar-collapse collapse” id=”navbar-collapsible”>
<ul class=”nav navbar-nav”>
<li ><a href=”#start”>Početna</a></li>
<li><a href=”#history”>Istorijski podaci</a></li>
<li><a href=”#settings”>Podešavanja</a></li>
<li>&nbsp;</li>
</ul>
</div>
</div>
</nav>
<section class=”container-fluid” id=”start”>
<div class=”container”>
<div class=”page-header”>
<h1>Daljinsko upravljanje sistemom zalivanja</h1>
</div>
<?php
include(‘appData.php’);
include(‘weatherForecast.php’);
function convertDate($strDate){
$newStrDate = substr ($strDate,8,2).”.”.substr($strDate,5,2).”.”.substr($strDate,
0,4).substr($strDate,10,9);
return $newStrDate;
}
?>
<div class=”row”>
<div class=”col-sm-6 col-lg-4”>
<p class=”text-muted”>Temperatura: <?php echo $temperature;?> *C </p>
<p class=”text-muted”>Vlažnost: <?php echo $humidity;?> % </p>
<p class=”text-muted”>Izmereno: <?php echo convertDate($time);?> </p>
</div>
<div class=”col-sm-6 col-lg-4”>
<span class=”text-muted”> Prognoza za danas: </span>
<table>
<tr>
<td>
<ul>
<li><span class=”text-muted”> <?php echo $weatherDesc;?></span> </li>
<li><span class=”text-muted”> Maksimalna temperatura: <?php echo $maxtempC;?> *C.</
span> </li>
<li><span class=”text-muted”> Minimalna temperatura: <?php echo $mintempC;?> *C.</span>
</li>
</ul>
</td>
<td> <?php echo (‘<img src=”’.$weatherIconUrl.’” width=”60” height=”60” >’);?> </td>
</tr>
</table>
</div>
</div>
<div class=”row”>
<div class=”col-sm-6 col-lg-4”>
<br> <br>
<p>
<span class=”text-muted”>Status sistema: </span> <input id=”switch-state”
name=”pumpa” <?php if(isset($statusSistema) && $statusSistema==1) { echo ‘checked’;} ?>
type=”checkbox” data-inverse=”true” data-on-color=”success” data-off-color=”primary”>
</p>
<p>
<form method=”POST”>
<button type=”button” data-switch-set=”state” data-switch-value=”true” name
= “button_start” class=”btn btn-default”>Uključi zalivanje</button>
<button type=”button” data-switch-set=”state” data-switch-value=”false” name =“button_stop” class=”btn btn-default”>Isključi zalivanje</button>
</form>
</p>
</div>
<div class=”col-sm-6 col-lg-4”>
<br> <br>
<div class=”panel panel-default”>
<div class=”panel-heading”>
<h4 class=”panel-title”>Datum/vreme poslednjeg zalivanja:</h4>
</div>
<div class=”panel-body” id=”poslednjeZalivanje”>
<?php echo (‘ <input type=”text” value=”’.convertDate($lastWatering).’” name=”lastWatering”
style=”border: none”>’);?>
</div>
</div>
</div>
</div>
</div>
<br> <br>
</section>
<section class=”container-fluid” id=”history”>
<div class=”container”>
<div class=”page-header”>
<h1>Istorijski podaci</h1>
</div>
<div class=”row”>
<div class=”col-sm-6 col-lg-4” id=”material” style=”width: 900px; height: 500px”
align=”center” >
</div>
</div>
</div>
<br> <br>
</section>
<section class=”container-fluid” id=”settings”>
<div class=”container”>
<?php include(‘userSettings.php’); ?>
<div class=”page-header”>
<h1>Podešavanja</h1>
</div>
<h3> Podešavanja sistema automatskog zalivanja: </h3>
<br>
<form class=”form-horizontal” action=”index.php//settings” method=”POST”>
<div class=”form-group”>
<label for=”startTime” class=”col-sm-4 control-label”>Vreme automatskog uključivanja
sistema zalivanja:</label>
<div class=”col-sm-2”>
<?php echo (‘<input type=”time” class=”form-control” id=”startTime” name = “startTime”
	value= “’.$startTime.’”>’);?>
</div>
<p class=”help-block”>U ovo predefinisano vreme će se sistem automatski uključivati
svakog dana.</p>
</div>
<div class=”form-group”>
<label for=”maxTemp” class=”col-sm-4 control-label”>Maksimalna temperatura po kojoj
je dozvoljeno zalivanje: </label>
<div class=”col-sm-2”>
<select class=”form-control” id=”maxTemp” name = “maxTemp” >
<option <?php if($maxTemp == ‘25’) { echo ‘selected’;} ?> >25</option>
<option <?php if($maxTemp == ‘30’) { echo ‘selected’;} ?>>30</option>
<option <?php if($maxTemp == ‘35’) { echo ‘selected’;} ?>>35</option>
<option <?php if($maxTemp == ‘40’) { echo ‘selected’;} ?>>40</option>
</select>
</div>
<p class=”help-block”>Ukoliko je temperatura veća od ove predefinisane vrednosti, automatsko
zalivanje će biti onemogućeno.</p>
</div>
<div class=”form-group”>
<label for=”maxHum” class=”col-sm-4 control-label”>Maksimalna vlažnost po kojoj je
dozvoljeno zalivanje: </label>
<div class=”col-sm-2”>
<select class=”form-control” id=”maxHum” name = “maxHum” >
<option <?php if($maxHum == ‘70 %’) { echo ‘selected’;} ?>>70 %</option>
<option <?php if($maxHum == ‘75 %’) { echo ‘selected’;} ?>>75 %</option>
<option <?php if($maxHum == ‘80 %’) { echo ‘selected’;} ?>>80 %</option>
<option <?php if($maxHum == ‘85 %’) { echo ‘selected’;} ?>>85 %</option>
<option <?php if($maxHum == ‘90 %’) { echo ‘selected’;} ?>>90 %</option>
<option <?php if($maxHum == ‘95 %’) { echo ‘selected’;} ?>>95 %</option>
</select>
</div>
<p class=”help-block”>Ukoliko je vlažnost vazduha veća od ove predefinisane vrednosti,
automatsko zalivanje će biti onemogućeno.</p>
</div>
<div class=”form-group”>
<div class=”col-sm-offset-4 col-sm-10”>
<button type=”submit” class=”btn btn-default” name=”main_settings”>Sačuvaj
podešavanja</button>
</div>
</div>
</form>
<br> <hr> <br>
<h3 id=”settingsUser”> Podešavanje sistema upozoravanja: </h3>
<br>
<form class=”form-horizontal” action=”index.php#settingsUser” method=”POST”>
<div class=”form-group”>
<label for=”warningEmail” class=”col-sm-4 control-label”>Email adresa:</label>
<div class=”col-sm-2”>
<?php echo (‘<input type=”email” class=”form-control” id=”warningEmail” name=”warning-
Email” placeholder=”Unesi email” value= “’.$warningEmail.’”>’);?>
</div>
<p class=”help-block”>Sistem će automatski slati upozorenja na ovu email adresu.</p>
</div>
<div class=”form-group”>
<label for=”warningTime” class=”col-sm-4 control-label”>Učestalost slanja upozorenja:</
label>
<div class=”col-sm-2”>
<select class=”form-control” id=”warningTime” name=”warningTime”>
<option <?php if($warningTime == ‘1h’) { echo ‘selected’;} ?>>1h</option>
<option <?php if($warningTime == ‘2h’) { echo ‘selected’;} ?>>2h</option>
<option <?php if($warningTime == ‘4h’) { echo ‘selected’;} ?>>4h</option>
<option <?php if($warningTime == ‘8h’) { echo ‘selected’;} ?>>8h</option>
<option <?php if($warningTime == ‘12h’) { echo ‘selected’;} ?>>12h</option>
<option <?php if($warningTime == ‘24h’) { echo ‘selected’;} ?>>24h</option>
</select>
</div>
<p class=”help-block”>Počev of 8h ujutru, sistem će slati upozorenja po ovoj dinamici.</
p>
</div>
<div class=”form-group”>
<label for=”warningMaxTemp” class=”col-sm-4 control-label”>Upozorenje o visini temperature:
</label>
<div class=”col-sm-2”>
<select class=”form-control” id=”warningMaxTemp” name=”warningMaxTemp”>
<option <?php if($warningMaxTemp == ‘25’) { echo ‘selected’;} ?>>25</option>
<option <?php if($warningMaxTemp == ‘30’) { echo ‘selected’;} ?>>30</option>
<option <?php if($warningMaxTemp == ‘35’) { echo ‘selected’;} ?>>35</option>
<option <?php if($warningMaxTemp == ‘40’) { echo ‘selected’;} ?>>40</option>
</select>
</div>
<p class=”help-block”>Ukoliko je temperatura veća od ove predefinisane vrednosti, sistem
će slati upozorenje.</p>
</div>
<div class=”form-group”>
<label for=”warningMinHum” class=”col-sm-4 control-label”>Upozorenje o vlažnosti
vazduha: </label>
<div class=”col-sm-2”>
<select class=”form-control” id=”warningMinHum” name=”warningMinHum”>
<option <?php if($warningMinHum == ‘10 %’) { echo ‘selected’;} ?>>10 %</option>
<option <?php if($warningMinHum == ‘15 %’) { echo ‘selected’;} ?>>15 %</option>
<option <?php if($warningMinHum == ‘20 %’) { echo ‘selected’;} ?>>20 %</option>
<option <?php if($warningMinHum == ‘25 %’) { echo ‘selected’;} ?>>25 %</option>
<option <?php if($warningMinHum == ‘30 %’) { echo ‘selected’;} ?>>30 %</option>
<option <?php if($warningMinHum == ‘35 %’) { echo ‘selected’;} ?>>35 %</option>
</select>
</div>
<p class=”help-block”>Ukoliko je vlažnost vazduha niža od ove predefinisane vrednosti,
sistem će slati upozorenje.</p>
</div>
<div class=”form-group”>
<div class=”col-sm-offset-4 col-sm-10”>
<button type=”submit” class=”btn btn-default” name=”warning_settings”>Sačuvaj
podešavanja</button>
</div>
</div>
</form>
</div>
<br> <br>
</section>
<section class=”container-fluid” >
<div class=”container”>
<br> <br> <br> <hr> <br>
<div class=”container”>
<p class=”text-center”> Vežbe iz predmeta Internet inteligentnih uređaja, maj 2015 </p>
<p class=”text-center”> <a href=”http://www.elab.rs/”> Katedra za elektrosnko
poslovanje, Fakultet organizacionih nauka </a>
</p>
</div>
</div>
</section>
<!-- Bootstrap core JavaScript
================================================== -->
<!-- Placed at the end of the document so the pages load faster -->
<script src=”./js/bootstrap.js”></script>
<script src=”./js/bootstrap.min.js”></script>
<script src=”./js/highlight.js”></script>
<script src=”./js/bootstrap-switch.js”></script>
<script src=”./js/main.js”></script>
</body>
</html>